package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__string, __boolean}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateVoiceTemplateRequest(
    createNewVersion: Optional[__boolean] = Optional.Absent,
    templateName: __string,
    version: Optional[__string] = Optional.Absent,
    voiceTemplateRequest: zio.aws.pinpoint.model.VoiceTemplateRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateVoiceTemplateRequest = {
    import UpdateVoiceTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateVoiceTemplateRequest
      .builder()
      .optionallyWith(createNewVersion.map(value => value: java.lang.Boolean))(
        _.createNewVersion
      )
      .templateName(templateName: java.lang.String)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .voiceTemplateRequest(voiceTemplateRequest.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateVoiceTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateVoiceTemplateRequest.wrap(buildAwsValue())
}
object UpdateVoiceTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateVoiceTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateVoiceTemplateRequest =
      zio.aws.pinpoint.model.UpdateVoiceTemplateRequest(
        createNewVersion.map(value => value),
        templateName,
        version.map(value => value),
        voiceTemplateRequest.asEditable
      )
    def createNewVersion: Optional[__boolean]
    def templateName: __string
    def version: Optional[__string]
    def voiceTemplateRequest
        : zio.aws.pinpoint.model.VoiceTemplateRequest.ReadOnly
    def getCreateNewVersion: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("createNewVersion", createNewVersion)
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
    def getVoiceTemplateRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.VoiceTemplateRequest.ReadOnly
    ] = ZIO.succeed(voiceTemplateRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateVoiceTemplateRequest
  ) extends zio.aws.pinpoint.model.UpdateVoiceTemplateRequest.ReadOnly {
    override val createNewVersion: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.createNewVersion())
      .map(value => value: __boolean)
    override val templateName: __string = impl.templateName(): __string
    override val version: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: __string)
    override val voiceTemplateRequest
        : zio.aws.pinpoint.model.VoiceTemplateRequest.ReadOnly =
      zio.aws.pinpoint.model.VoiceTemplateRequest
        .wrap(impl.voiceTemplateRequest())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateVoiceTemplateRequest
  ): zio.aws.pinpoint.model.UpdateVoiceTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
