package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VoiceTemplateRequest(
    body: Optional[__string] = Optional.Absent,
    defaultSubstitutions: Optional[__string] = Optional.Absent,
    languageCode: Optional[__string] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent,
    templateDescription: Optional[__string] = Optional.Absent,
    voiceId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.VoiceTemplateRequest = {
    import VoiceTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.VoiceTemplateRequest
      .builder()
      .optionallyWith(body.map(value => value: java.lang.String))(_.body)
      .optionallyWith(
        defaultSubstitutions.map(value => value: java.lang.String)
      )(_.defaultSubstitutions)
      .optionallyWith(languageCode.map(value => value: java.lang.String))(
        _.languageCode
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        templateDescription.map(value => value: java.lang.String)
      )(_.templateDescription)
      .optionallyWith(voiceId.map(value => value: java.lang.String))(_.voiceId)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.VoiceTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.VoiceTemplateRequest.wrap(buildAwsValue())
}
object VoiceTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.VoiceTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.VoiceTemplateRequest =
      zio.aws.pinpoint.model.VoiceTemplateRequest(
        body.map(value => value),
        defaultSubstitutions.map(value => value),
        languageCode.map(value => value),
        tags.map(value => value),
        templateDescription.map(value => value),
        voiceId.map(value => value)
      )
    def body: Optional[__string]
    def defaultSubstitutions: Optional[__string]
    def languageCode: Optional[__string]
    def tags: Optional[Map[__string, __string]]
    def templateDescription: Optional[__string]
    def voiceId: Optional[__string]
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getDefaultSubstitutions: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("defaultSubstitutions", defaultSubstitutions)
    def getLanguageCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateDescription", templateDescription)
    def getVoiceId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("voiceId", voiceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.VoiceTemplateRequest
  ) extends zio.aws.pinpoint.model.VoiceTemplateRequest.ReadOnly {
    override val body: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.body())
      .map(value => value: __string)
    override val defaultSubstitutions: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultSubstitutions())
        .map(value => value: __string)
    override val languageCode: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.languageCode())
      .map(value => value: __string)
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val templateDescription: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateDescription())
      .map(value => value: __string)
    override val voiceId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.voiceId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.VoiceTemplateRequest
  ): zio.aws.pinpoint.model.VoiceTemplateRequest.ReadOnly = new Wrapper(impl)
}
