package zio.aws.polly
import software.amazon.awssdk.services.polly.PollyAsyncClient
import zio.aws.polly.model.ListLexiconsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.polly.model.{
  ListLexiconsRequest,
  DeleteLexiconRequest,
  StartSpeechSynthesisTaskRequest,
  ListSpeechSynthesisTasksRequest,
  GetSpeechSynthesisTaskRequest,
  DescribeVoicesRequest,
  SynthesizeSpeechRequest,
  GetLexiconRequest,
  PutLexiconRequest
}
import zio.stream.ZStream
object PollyMock extends Mock[Polly] {
  object ListLexicons
      extends Stream[
        ListLexiconsRequest,
        AwsError,
        zio.aws.polly.model.LexiconDescription.ReadOnly
      ]
  object ListLexiconsPaginated
      extends Effect[ListLexiconsRequest, AwsError, ReadOnly]
  object PutLexicon
      extends Effect[
        PutLexiconRequest,
        AwsError,
        zio.aws.polly.model.PutLexiconResponse.ReadOnly
      ]
  object ListSpeechSynthesisTasks
      extends Stream[
        ListSpeechSynthesisTasksRequest,
        AwsError,
        zio.aws.polly.model.SynthesisTask.ReadOnly
      ]
  object ListSpeechSynthesisTasksPaginated
      extends Effect[
        ListSpeechSynthesisTasksRequest,
        AwsError,
        zio.aws.polly.model.ListSpeechSynthesisTasksResponse.ReadOnly
      ]
  object GetLexicon
      extends Effect[
        GetLexiconRequest,
        AwsError,
        zio.aws.polly.model.GetLexiconResponse.ReadOnly
      ]
  object StartSpeechSynthesisTask
      extends Effect[
        StartSpeechSynthesisTaskRequest,
        AwsError,
        zio.aws.polly.model.StartSpeechSynthesisTaskResponse.ReadOnly
      ]
  object GetSpeechSynthesisTask
      extends Effect[
        GetSpeechSynthesisTaskRequest,
        AwsError,
        zio.aws.polly.model.GetSpeechSynthesisTaskResponse.ReadOnly
      ]
  object SynthesizeSpeech
      extends Effect[SynthesizeSpeechRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.polly.model.SynthesizeSpeechResponse.ReadOnly,
        Byte
      ]]
  object DeleteLexicon
      extends Effect[
        DeleteLexiconRequest,
        AwsError,
        zio.aws.polly.model.DeleteLexiconResponse.ReadOnly
      ]
  object DescribeVoices
      extends Stream[
        DescribeVoicesRequest,
        AwsError,
        zio.aws.polly.model.Voice.ReadOnly
      ]
  object DescribeVoicesPaginated
      extends Effect[
        DescribeVoicesRequest,
        AwsError,
        zio.aws.polly.model.DescribeVoicesResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Polly] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Polly {
          val api: PollyAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Polly = this
          def listLexicons(request: ListLexiconsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.polly.model.LexiconDescription.ReadOnly
          ] = rts.unsafeRun(proxy(ListLexicons, request))
          def listLexiconsPaginated(
              request: ListLexiconsRequest
          ): IO[AwsError, ReadOnly] = proxy(ListLexiconsPaginated, request)
          def putLexicon(
              request: PutLexiconRequest
          ): IO[AwsError, zio.aws.polly.model.PutLexiconResponse.ReadOnly] =
            proxy(PutLexicon, request)
          def listSpeechSynthesisTasks(
              request: ListSpeechSynthesisTasksRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.polly.model.SynthesisTask.ReadOnly
          ] = rts.unsafeRun(proxy(ListSpeechSynthesisTasks, request))
          def listSpeechSynthesisTasksPaginated(
              request: ListSpeechSynthesisTasksRequest
          ): IO[
            AwsError,
            zio.aws.polly.model.ListSpeechSynthesisTasksResponse.ReadOnly
          ] = proxy(ListSpeechSynthesisTasksPaginated, request)
          def getLexicon(
              request: GetLexiconRequest
          ): IO[AwsError, zio.aws.polly.model.GetLexiconResponse.ReadOnly] =
            proxy(GetLexicon, request)
          def startSpeechSynthesisTask(
              request: StartSpeechSynthesisTaskRequest
          ): IO[
            AwsError,
            zio.aws.polly.model.StartSpeechSynthesisTaskResponse.ReadOnly
          ] = proxy(StartSpeechSynthesisTask, request)
          def getSpeechSynthesisTask(
              request: GetSpeechSynthesisTaskRequest
          ): IO[
            AwsError,
            zio.aws.polly.model.GetSpeechSynthesisTaskResponse.ReadOnly
          ] = proxy(GetSpeechSynthesisTask, request)
          def synthesizeSpeech(
              request: SynthesizeSpeechRequest
          ): IO[AwsError, StreamingOutputResult[
            Any,
            zio.aws.polly.model.SynthesizeSpeechResponse.ReadOnly,
            Byte
          ]] = proxy(SynthesizeSpeech, request)
          def deleteLexicon(
              request: DeleteLexiconRequest
          ): IO[AwsError, zio.aws.polly.model.DeleteLexiconResponse.ReadOnly] =
            proxy(DeleteLexicon, request)
          def describeVoices(
              request: DescribeVoicesRequest
          ): ZStream[Any, AwsError, zio.aws.polly.model.Voice.ReadOnly] =
            rts.unsafeRun(proxy(DescribeVoices, request))
          def describeVoicesPaginated(
              request: DescribeVoicesRequest
          ): IO[AwsError, zio.aws.polly.model.DescribeVoicesResponse.ReadOnly] =
            proxy(DescribeVoicesPaginated, request)
        }
      }
    }
    .toLayer
}
