package zio.aws.polly.model
import zio.aws.polly.model.primitives.LexiconName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteLexiconRequest(name: LexiconName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.polly.model.DeleteLexiconRequest = {
    import DeleteLexiconRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.polly.model.DeleteLexiconRequest
      .builder()
      .name(LexiconName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.polly.model.DeleteLexiconRequest.ReadOnly =
    zio.aws.polly.model.DeleteLexiconRequest.wrap(buildAwsValue())
}
object DeleteLexiconRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.polly.model.DeleteLexiconRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.polly.model.DeleteLexiconRequest =
      zio.aws.polly.model.DeleteLexiconRequest(name)
    def name: LexiconName
    def getName: ZIO[Any, Nothing, LexiconName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.polly.model.DeleteLexiconRequest
  ) extends zio.aws.polly.model.DeleteLexiconRequest.ReadOnly {
    override val name: LexiconName =
      zio.aws.polly.model.primitives.LexiconName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.polly.model.DeleteLexiconRequest
  ): zio.aws.polly.model.DeleteLexiconRequest.ReadOnly = new Wrapper(impl)
}
