package zio.aws.polly.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetLexiconResponse(
    lexicon: Option[zio.aws.polly.model.Lexicon] = None,
    lexiconAttributes: Option[zio.aws.polly.model.LexiconAttributes] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.polly.model.GetLexiconResponse = {
    import GetLexiconResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.polly.model.GetLexiconResponse
      .builder()
      .optionallyWith(lexicon.map(value => value.buildAwsValue()))(_.lexicon)
      .optionallyWith(lexiconAttributes.map(value => value.buildAwsValue()))(
        _.lexiconAttributes
      )
      .build()
  }
  def asReadOnly: zio.aws.polly.model.GetLexiconResponse.ReadOnly =
    zio.aws.polly.model.GetLexiconResponse.wrap(buildAwsValue())
}
object GetLexiconResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.polly.model.GetLexiconResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.polly.model.GetLexiconResponse =
      zio.aws.polly.model.GetLexiconResponse(
        lexicon.map(value => value.asEditable),
        lexiconAttributes.map(value => value.asEditable)
      )
    def lexicon: Option[zio.aws.polly.model.Lexicon.ReadOnly]
    def lexiconAttributes
        : Option[zio.aws.polly.model.LexiconAttributes.ReadOnly]
    def getLexicon: ZIO[Any, AwsError, zio.aws.polly.model.Lexicon.ReadOnly] =
      AwsError.unwrapOptionField("lexicon", lexicon)
    def getLexiconAttributes
        : ZIO[Any, AwsError, zio.aws.polly.model.LexiconAttributes.ReadOnly] =
      AwsError.unwrapOptionField("lexiconAttributes", lexiconAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.polly.model.GetLexiconResponse
  ) extends zio.aws.polly.model.GetLexiconResponse.ReadOnly {
    override val lexicon: Option[zio.aws.polly.model.Lexicon.ReadOnly] = scala
      .Option(impl.lexicon())
      .map(value => zio.aws.polly.model.Lexicon.wrap(value))
    override val lexiconAttributes
        : Option[zio.aws.polly.model.LexiconAttributes.ReadOnly] = scala
      .Option(impl.lexiconAttributes())
      .map(value => zio.aws.polly.model.LexiconAttributes.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.polly.model.GetLexiconResponse
  ): zio.aws.polly.model.GetLexiconResponse.ReadOnly = new Wrapper(impl)
}
