package zio.aws.polly.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetSpeechSynthesisTaskResponse(
    synthesisTask: Option[zio.aws.polly.model.SynthesisTask] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.polly.model.GetSpeechSynthesisTaskResponse = {
    import GetSpeechSynthesisTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.polly.model.GetSpeechSynthesisTaskResponse
      .builder()
      .optionallyWith(synthesisTask.map(value => value.buildAwsValue()))(
        _.synthesisTask
      )
      .build()
  }
  def asReadOnly: zio.aws.polly.model.GetSpeechSynthesisTaskResponse.ReadOnly =
    zio.aws.polly.model.GetSpeechSynthesisTaskResponse.wrap(buildAwsValue())
}
object GetSpeechSynthesisTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.polly.model.GetSpeechSynthesisTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.polly.model.GetSpeechSynthesisTaskResponse =
      zio.aws.polly.model.GetSpeechSynthesisTaskResponse(
        synthesisTask.map(value => value.asEditable)
      )
    def synthesisTask: Option[zio.aws.polly.model.SynthesisTask.ReadOnly]
    def getSynthesisTask
        : ZIO[Any, AwsError, zio.aws.polly.model.SynthesisTask.ReadOnly] =
      AwsError.unwrapOptionField("synthesisTask", synthesisTask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.polly.model.GetSpeechSynthesisTaskResponse
  ) extends zio.aws.polly.model.GetSpeechSynthesisTaskResponse.ReadOnly {
    override val synthesisTask
        : Option[zio.aws.polly.model.SynthesisTask.ReadOnly] = scala
      .Option(impl.synthesisTask())
      .map(value => zio.aws.polly.model.SynthesisTask.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.polly.model.GetSpeechSynthesisTaskResponse
  ): zio.aws.polly.model.GetSpeechSynthesisTaskResponse.ReadOnly = new Wrapper(
    impl
  )
}
