package zio.aws.polly.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.polly.model.primitives.{
  Alphabet,
  LastModified,
  LexemesCount,
  LexiconArn,
  Size
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LexiconAttributes(
    alphabet: Option[Alphabet] = None,
    languageCode: Option[zio.aws.polly.model.LanguageCode] = None,
    lastModified: Option[LastModified] = None,
    lexiconArn: Option[LexiconArn] = None,
    lexemesCount: Option[LexemesCount] = None,
    size: Option[Size] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.polly.model.LexiconAttributes = {
    import LexiconAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.polly.model.LexiconAttributes
      .builder()
      .optionallyWith(
        alphabet.map(value => Alphabet.unwrap(value): java.lang.String)
      )(_.alphabet)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        lastModified.map(value => LastModified.unwrap(value): Instant)
      )(_.lastModified)
      .optionallyWith(
        lexiconArn.map(value => LexiconArn.unwrap(value): java.lang.String)
      )(_.lexiconArn)
      .optionallyWith(
        lexemesCount.map(value => LexemesCount.unwrap(value): Integer)
      )(_.lexemesCount)
      .optionallyWith(size.map(value => Size.unwrap(value): Integer))(_.size)
      .build()
  }
  def asReadOnly: zio.aws.polly.model.LexiconAttributes.ReadOnly =
    zio.aws.polly.model.LexiconAttributes.wrap(buildAwsValue())
}
object LexiconAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.polly.model.LexiconAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.polly.model.LexiconAttributes =
      zio.aws.polly.model.LexiconAttributes(
        alphabet.map(value => value),
        languageCode.map(value => value),
        lastModified.map(value => value),
        lexiconArn.map(value => value),
        lexemesCount.map(value => value),
        size.map(value => value)
      )
    def alphabet: Option[Alphabet]
    def languageCode: Option[zio.aws.polly.model.LanguageCode]
    def lastModified: Option[LastModified]
    def lexiconArn: Option[LexiconArn]
    def lexemesCount: Option[LexemesCount]
    def size: Option[Size]
    def getAlphabet: ZIO[Any, AwsError, Alphabet] =
      AwsError.unwrapOptionField("alphabet", alphabet)
    def getLanguageCode: ZIO[Any, AwsError, zio.aws.polly.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getLastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getLexiconArn: ZIO[Any, AwsError, LexiconArn] =
      AwsError.unwrapOptionField("lexiconArn", lexiconArn)
    def getLexemesCount: ZIO[Any, AwsError, LexemesCount] =
      AwsError.unwrapOptionField("lexemesCount", lexemesCount)
    def getSize: ZIO[Any, AwsError, Size] =
      AwsError.unwrapOptionField("size", size)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.polly.model.LexiconAttributes
  ) extends zio.aws.polly.model.LexiconAttributes.ReadOnly {
    override val alphabet: Option[Alphabet] = scala
      .Option(impl.alphabet())
      .map(value => zio.aws.polly.model.primitives.Alphabet(value))
    override val languageCode: Option[zio.aws.polly.model.LanguageCode] = scala
      .Option(impl.languageCode())
      .map(value => zio.aws.polly.model.LanguageCode.wrap(value))
    override val lastModified: Option[LastModified] = scala
      .Option(impl.lastModified())
      .map(value => zio.aws.polly.model.primitives.LastModified(value))
    override val lexiconArn: Option[LexiconArn] = scala
      .Option(impl.lexiconArn())
      .map(value => zio.aws.polly.model.primitives.LexiconArn(value))
    override val lexemesCount: Option[LexemesCount] = scala
      .Option(impl.lexemesCount())
      .map(value => zio.aws.polly.model.primitives.LexemesCount(value))
    override val size: Option[Size] = scala
      .Option(impl.size())
      .map(value => zio.aws.polly.model.primitives.Size(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.polly.model.LexiconAttributes
  ): zio.aws.polly.model.LexiconAttributes.ReadOnly = new Wrapper(impl)
}
