package zio.aws.polly.model
import zio.aws.polly.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListLexiconsRequest(nextToken: Option[NextToken] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.polly.model.ListLexiconsRequest = {
    import ListLexiconsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.polly.model.ListLexiconsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.polly.model.ListLexiconsRequest.ReadOnly =
    zio.aws.polly.model.ListLexiconsRequest.wrap(buildAwsValue())
}
object ListLexiconsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.polly.model.ListLexiconsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.polly.model.ListLexiconsRequest =
      zio.aws.polly.model.ListLexiconsRequest(nextToken.map(value => value))
    def nextToken: Option[NextToken]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.polly.model.ListLexiconsRequest
  ) extends zio.aws.polly.model.ListLexiconsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.polly.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.polly.model.ListLexiconsRequest
  ): zio.aws.polly.model.ListLexiconsRequest.ReadOnly = new Wrapper(impl)
}
