package zio.aws.polly.model
import java.lang.Integer
import zio.aws.polly.model.primitives.{NextToken, MaxResults}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListSpeechSynthesisTasksRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None,
    status: Option[zio.aws.polly.model.TaskStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest = {
    import ListSpeechSynthesisTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.polly.model.ListSpeechSynthesisTasksRequest.ReadOnly =
    zio.aws.polly.model.ListSpeechSynthesisTasksRequest.wrap(buildAwsValue())
}
object ListSpeechSynthesisTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.polly.model.ListSpeechSynthesisTasksRequest =
      zio.aws.polly.model.ListSpeechSynthesisTasksRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        status.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def status: Option[zio.aws.polly.model.TaskStatus]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStatus: ZIO[Any, AwsError, zio.aws.polly.model.TaskStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest
  ) extends zio.aws.polly.model.ListSpeechSynthesisTasksRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.polly.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.polly.model.primitives.NextToken(value))
    override val status: Option[zio.aws.polly.model.TaskStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.polly.model.TaskStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest
  ): zio.aws.polly.model.ListSpeechSynthesisTasksRequest.ReadOnly = new Wrapper(
    impl
  )
}
