package zio.aws.polly.model
import zio.aws.polly.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListSpeechSynthesisTasksResponse(
    nextToken: Option[NextToken] = None,
    synthesisTasks: Option[Iterable[zio.aws.polly.model.SynthesisTask]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksResponse = {
    import ListSpeechSynthesisTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        synthesisTasks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.synthesisTasks)
      .build()
  }
  def asReadOnly
      : zio.aws.polly.model.ListSpeechSynthesisTasksResponse.ReadOnly =
    zio.aws.polly.model.ListSpeechSynthesisTasksResponse.wrap(buildAwsValue())
}
object ListSpeechSynthesisTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.polly.model.ListSpeechSynthesisTasksResponse =
      zio.aws.polly.model.ListSpeechSynthesisTasksResponse(
        nextToken.map(value => value),
        synthesisTasks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def synthesisTasks: Option[List[zio.aws.polly.model.SynthesisTask.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSynthesisTasks
        : ZIO[Any, AwsError, List[zio.aws.polly.model.SynthesisTask.ReadOnly]] =
      AwsError.unwrapOptionField("synthesisTasks", synthesisTasks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksResponse
  ) extends zio.aws.polly.model.ListSpeechSynthesisTasksResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.polly.model.primitives.NextToken(value))
    override val synthesisTasks
        : Option[List[zio.aws.polly.model.SynthesisTask.ReadOnly]] = scala
      .Option(impl.synthesisTasks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.polly.model.SynthesisTask.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksResponse
  ): zio.aws.polly.model.ListSpeechSynthesisTasksResponse.ReadOnly =
    new Wrapper(impl)
}
