package zio.aws.polly.model
import scala.jdk.CollectionConverters._
sealed trait OutputFormat {
  def unwrap: software.amazon.awssdk.services.polly.model.OutputFormat
}
object OutputFormat {
  def wrap(
      value: software.amazon.awssdk.services.polly.model.OutputFormat
  ): zio.aws.polly.model.OutputFormat = value match {
    case software.amazon.awssdk.services.polly.model.OutputFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.polly.model.OutputFormat.JSON =>
      val r = json
      r
    case software.amazon.awssdk.services.polly.model.OutputFormat.MP3 =>
      val r = mp3
      r
    case software.amazon.awssdk.services.polly.model.OutputFormat.OGG_VORBIS =>
      val r = ogg_vorbis
      r
    case software.amazon.awssdk.services.polly.model.OutputFormat.PCM =>
      val r = pcm
      r
  }
  case object unknownToSdkVersion extends zio.aws.polly.model.OutputFormat {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.OutputFormat =
      software.amazon.awssdk.services.polly.model.OutputFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object json extends zio.aws.polly.model.OutputFormat {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.OutputFormat =
      software.amazon.awssdk.services.polly.model.OutputFormat.JSON
  }
  case object mp3 extends zio.aws.polly.model.OutputFormat {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.OutputFormat =
      software.amazon.awssdk.services.polly.model.OutputFormat.MP3
  }
  case object ogg_vorbis extends zio.aws.polly.model.OutputFormat {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.OutputFormat =
      software.amazon.awssdk.services.polly.model.OutputFormat.OGG_VORBIS
  }
  case object pcm extends zio.aws.polly.model.OutputFormat {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.OutputFormat =
      software.amazon.awssdk.services.polly.model.OutputFormat.PCM
  }
}
