package zio.aws.polly.model
import zio.aws.polly.model.primitives.{LexiconContent, LexiconName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutLexiconRequest(name: LexiconName, content: LexiconContent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.polly.model.PutLexiconRequest = {
    import PutLexiconRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.polly.model.PutLexiconRequest
      .builder()
      .name(LexiconName.unwrap(name): java.lang.String)
      .content(LexiconContent.unwrap(content): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.polly.model.PutLexiconRequest.ReadOnly =
    zio.aws.polly.model.PutLexiconRequest.wrap(buildAwsValue())
}
object PutLexiconRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.polly.model.PutLexiconRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.polly.model.PutLexiconRequest =
      zio.aws.polly.model.PutLexiconRequest(name, content)
    def name: LexiconName
    def content: LexiconContent
    def getName: ZIO[Any, Nothing, LexiconName] = ZIO.succeed(name)
    def getContent: ZIO[Any, Nothing, LexiconContent] = ZIO.succeed(content)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.polly.model.PutLexiconRequest
  ) extends zio.aws.polly.model.PutLexiconRequest.ReadOnly {
    override val name: LexiconName =
      zio.aws.polly.model.primitives.LexiconName(impl.name())
    override val content: LexiconContent =
      zio.aws.polly.model.primitives.LexiconContent(impl.content())
  }
  def wrap(
      impl: software.amazon.awssdk.services.polly.model.PutLexiconRequest
  ): zio.aws.polly.model.PutLexiconRequest.ReadOnly = new Wrapper(impl)
}
