package zio.aws.polly.model
import scala.jdk.CollectionConverters._
sealed trait SpeechMarkType {
  def unwrap: software.amazon.awssdk.services.polly.model.SpeechMarkType
}
object SpeechMarkType {
  def wrap(
      value: software.amazon.awssdk.services.polly.model.SpeechMarkType
  ): zio.aws.polly.model.SpeechMarkType = value match {
    case software.amazon.awssdk.services.polly.model.SpeechMarkType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.polly.model.SpeechMarkType.SENTENCE =>
      val r = sentence
      r
    case software.amazon.awssdk.services.polly.model.SpeechMarkType.SSML =>
      val r = ssml
      r
    case software.amazon.awssdk.services.polly.model.SpeechMarkType.VISEME =>
      val r = viseme
      r
    case software.amazon.awssdk.services.polly.model.SpeechMarkType.WORD =>
      val r = word
      r
  }
  case object unknownToSdkVersion extends zio.aws.polly.model.SpeechMarkType {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.SpeechMarkType =
      software.amazon.awssdk.services.polly.model.SpeechMarkType.UNKNOWN_TO_SDK_VERSION
  }
  case object sentence extends zio.aws.polly.model.SpeechMarkType {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.SpeechMarkType =
      software.amazon.awssdk.services.polly.model.SpeechMarkType.SENTENCE
  }
  case object ssml extends zio.aws.polly.model.SpeechMarkType {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.SpeechMarkType =
      software.amazon.awssdk.services.polly.model.SpeechMarkType.SSML
  }
  case object viseme extends zio.aws.polly.model.SpeechMarkType {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.SpeechMarkType =
      software.amazon.awssdk.services.polly.model.SpeechMarkType.VISEME
  }
  case object word extends zio.aws.polly.model.SpeechMarkType {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.SpeechMarkType =
      software.amazon.awssdk.services.polly.model.SpeechMarkType.WORD
  }
}
