package zio.aws.polly.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.polly.model.primitives.{
  SampleRate,
  OutputUri,
  SnsTopicArn,
  DateTime,
  LexiconName,
  TaskStatusReason,
  RequestCharacters,
  TaskId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SynthesisTask(
    engine: Option[zio.aws.polly.model.Engine] = None,
    taskId: Option[TaskId] = None,
    taskStatus: Option[zio.aws.polly.model.TaskStatus] = None,
    taskStatusReason: Option[TaskStatusReason] = None,
    outputUri: Option[OutputUri] = None,
    creationTime: Option[DateTime] = None,
    requestCharacters: Option[RequestCharacters] = None,
    snsTopicArn: Option[SnsTopicArn] = None,
    lexiconNames: Option[Iterable[LexiconName]] = None,
    outputFormat: Option[zio.aws.polly.model.OutputFormat] = None,
    sampleRate: Option[SampleRate] = None,
    speechMarkTypes: Option[Iterable[zio.aws.polly.model.SpeechMarkType]] =
      None,
    textType: Option[zio.aws.polly.model.TextType] = None,
    voiceId: Option[zio.aws.polly.model.VoiceId] = None,
    languageCode: Option[zio.aws.polly.model.LanguageCode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.polly.model.SynthesisTask = {
    import SynthesisTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.polly.model.SynthesisTask
      .builder()
      .optionallyWith(engine.map(value => value.unwrap))(_.engine)
      .optionallyWith(
        taskId.map(value => TaskId.unwrap(value): java.lang.String)
      )(_.taskId)
      .optionallyWith(taskStatus.map(value => value.unwrap))(_.taskStatus)
      .optionallyWith(
        taskStatusReason.map(value =>
          TaskStatusReason.unwrap(value): java.lang.String
        )
      )(_.taskStatusReason)
      .optionallyWith(
        outputUri.map(value => OutputUri.unwrap(value): java.lang.String)
      )(_.outputUri)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        requestCharacters.map(value => RequestCharacters.unwrap(value): Integer)
      )(_.requestCharacters)
      .optionallyWith(
        snsTopicArn.map(value => SnsTopicArn.unwrap(value): java.lang.String)
      )(_.snsTopicArn)
      .optionallyWith(
        lexiconNames.map(value =>
          value.map { item =>
            LexiconName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.lexiconNames)
      .optionallyWith(outputFormat.map(value => value.unwrap))(_.outputFormat)
      .optionallyWith(
        sampleRate.map(value => SampleRate.unwrap(value): java.lang.String)
      )(_.sampleRate)
      .optionallyWith(
        speechMarkTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.speechMarkTypesWithStrings)
      .optionallyWith(textType.map(value => value.unwrap))(_.textType)
      .optionallyWith(voiceId.map(value => value.unwrap))(_.voiceId)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .build()
  }
  def asReadOnly: zio.aws.polly.model.SynthesisTask.ReadOnly =
    zio.aws.polly.model.SynthesisTask.wrap(buildAwsValue())
}
object SynthesisTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.polly.model.SynthesisTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.polly.model.SynthesisTask =
      zio.aws.polly.model.SynthesisTask(
        engine.map(value => value),
        taskId.map(value => value),
        taskStatus.map(value => value),
        taskStatusReason.map(value => value),
        outputUri.map(value => value),
        creationTime.map(value => value),
        requestCharacters.map(value => value),
        snsTopicArn.map(value => value),
        lexiconNames.map(value => value),
        outputFormat.map(value => value),
        sampleRate.map(value => value),
        speechMarkTypes.map(value => value),
        textType.map(value => value),
        voiceId.map(value => value),
        languageCode.map(value => value)
      )
    def engine: Option[zio.aws.polly.model.Engine]
    def taskId: Option[TaskId]
    def taskStatus: Option[zio.aws.polly.model.TaskStatus]
    def taskStatusReason: Option[TaskStatusReason]
    def outputUri: Option[OutputUri]
    def creationTime: Option[DateTime]
    def requestCharacters: Option[RequestCharacters]
    def snsTopicArn: Option[SnsTopicArn]
    def lexiconNames: Option[List[LexiconName]]
    def outputFormat: Option[zio.aws.polly.model.OutputFormat]
    def sampleRate: Option[SampleRate]
    def speechMarkTypes: Option[List[zio.aws.polly.model.SpeechMarkType]]
    def textType: Option[zio.aws.polly.model.TextType]
    def voiceId: Option[zio.aws.polly.model.VoiceId]
    def languageCode: Option[zio.aws.polly.model.LanguageCode]
    def getEngine: ZIO[Any, AwsError, zio.aws.polly.model.Engine] =
      AwsError.unwrapOptionField("engine", engine)
    def getTaskId: ZIO[Any, AwsError, TaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
    def getTaskStatus: ZIO[Any, AwsError, zio.aws.polly.model.TaskStatus] =
      AwsError.unwrapOptionField("taskStatus", taskStatus)
    def getTaskStatusReason: ZIO[Any, AwsError, TaskStatusReason] =
      AwsError.unwrapOptionField("taskStatusReason", taskStatusReason)
    def getOutputUri: ZIO[Any, AwsError, OutputUri] =
      AwsError.unwrapOptionField("outputUri", outputUri)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getRequestCharacters: ZIO[Any, AwsError, RequestCharacters] =
      AwsError.unwrapOptionField("requestCharacters", requestCharacters)
    def getSnsTopicArn: ZIO[Any, AwsError, SnsTopicArn] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getLexiconNames: ZIO[Any, AwsError, List[LexiconName]] =
      AwsError.unwrapOptionField("lexiconNames", lexiconNames)
    def getOutputFormat: ZIO[Any, AwsError, zio.aws.polly.model.OutputFormat] =
      AwsError.unwrapOptionField("outputFormat", outputFormat)
    def getSampleRate: ZIO[Any, AwsError, SampleRate] =
      AwsError.unwrapOptionField("sampleRate", sampleRate)
    def getSpeechMarkTypes
        : ZIO[Any, AwsError, List[zio.aws.polly.model.SpeechMarkType]] =
      AwsError.unwrapOptionField("speechMarkTypes", speechMarkTypes)
    def getTextType: ZIO[Any, AwsError, zio.aws.polly.model.TextType] =
      AwsError.unwrapOptionField("textType", textType)
    def getVoiceId: ZIO[Any, AwsError, zio.aws.polly.model.VoiceId] =
      AwsError.unwrapOptionField("voiceId", voiceId)
    def getLanguageCode: ZIO[Any, AwsError, zio.aws.polly.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.polly.model.SynthesisTask
  ) extends zio.aws.polly.model.SynthesisTask.ReadOnly {
    override val engine: Option[zio.aws.polly.model.Engine] = scala
      .Option(impl.engine())
      .map(value => zio.aws.polly.model.Engine.wrap(value))
    override val taskId: Option[TaskId] = scala
      .Option(impl.taskId())
      .map(value => zio.aws.polly.model.primitives.TaskId(value))
    override val taskStatus: Option[zio.aws.polly.model.TaskStatus] = scala
      .Option(impl.taskStatus())
      .map(value => zio.aws.polly.model.TaskStatus.wrap(value))
    override val taskStatusReason: Option[TaskStatusReason] = scala
      .Option(impl.taskStatusReason())
      .map(value => zio.aws.polly.model.primitives.TaskStatusReason(value))
    override val outputUri: Option[OutputUri] = scala
      .Option(impl.outputUri())
      .map(value => zio.aws.polly.model.primitives.OutputUri(value))
    override val creationTime: Option[DateTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.polly.model.primitives.DateTime(value))
    override val requestCharacters: Option[RequestCharacters] = scala
      .Option(impl.requestCharacters())
      .map(value => zio.aws.polly.model.primitives.RequestCharacters(value))
    override val snsTopicArn: Option[SnsTopicArn] = scala
      .Option(impl.snsTopicArn())
      .map(value => zio.aws.polly.model.primitives.SnsTopicArn(value))
    override val lexiconNames: Option[List[LexiconName]] = scala
      .Option(impl.lexiconNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.polly.model.primitives.LexiconName(item)
        }.toList
      )
    override val outputFormat: Option[zio.aws.polly.model.OutputFormat] = scala
      .Option(impl.outputFormat())
      .map(value => zio.aws.polly.model.OutputFormat.wrap(value))
    override val sampleRate: Option[SampleRate] = scala
      .Option(impl.sampleRate())
      .map(value => zio.aws.polly.model.primitives.SampleRate(value))
    override val speechMarkTypes
        : Option[List[zio.aws.polly.model.SpeechMarkType]] = scala
      .Option(impl.speechMarkTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.polly.model.SpeechMarkType.wrap(item)
        }.toList
      )
    override val textType: Option[zio.aws.polly.model.TextType] = scala
      .Option(impl.textType())
      .map(value => zio.aws.polly.model.TextType.wrap(value))
    override val voiceId: Option[zio.aws.polly.model.VoiceId] = scala
      .Option(impl.voiceId())
      .map(value => zio.aws.polly.model.VoiceId.wrap(value))
    override val languageCode: Option[zio.aws.polly.model.LanguageCode] = scala
      .Option(impl.languageCode())
      .map(value => zio.aws.polly.model.LanguageCode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.polly.model.SynthesisTask
  ): zio.aws.polly.model.SynthesisTask.ReadOnly = new Wrapper(impl)
}
