package zio.aws.polly.model
import zio.aws.polly.model.primitives.{Text, SampleRate, LexiconName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SynthesizeSpeechRequest(
    engine: Option[zio.aws.polly.model.Engine] = None,
    languageCode: Option[zio.aws.polly.model.LanguageCode] = None,
    lexiconNames: Option[Iterable[LexiconName]] = None,
    outputFormat: zio.aws.polly.model.OutputFormat,
    sampleRate: Option[SampleRate] = None,
    speechMarkTypes: Option[Iterable[zio.aws.polly.model.SpeechMarkType]] =
      None,
    text: Text,
    textType: Option[zio.aws.polly.model.TextType] = None,
    voiceId: zio.aws.polly.model.VoiceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.polly.model.SynthesizeSpeechRequest = {
    import SynthesizeSpeechRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.polly.model.SynthesizeSpeechRequest
      .builder()
      .optionallyWith(engine.map(value => value.unwrap))(_.engine)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        lexiconNames.map(value =>
          value.map { item =>
            LexiconName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.lexiconNames)
      .outputFormat(outputFormat.unwrap)
      .optionallyWith(
        sampleRate.map(value => SampleRate.unwrap(value): java.lang.String)
      )(_.sampleRate)
      .optionallyWith(
        speechMarkTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.speechMarkTypesWithStrings)
      .text(Text.unwrap(text): java.lang.String)
      .optionallyWith(textType.map(value => value.unwrap))(_.textType)
      .voiceId(voiceId.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.polly.model.SynthesizeSpeechRequest.ReadOnly =
    zio.aws.polly.model.SynthesizeSpeechRequest.wrap(buildAwsValue())
}
object SynthesizeSpeechRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.polly.model.SynthesizeSpeechRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.polly.model.SynthesizeSpeechRequest =
      zio.aws.polly.model.SynthesizeSpeechRequest(
        engine.map(value => value),
        languageCode.map(value => value),
        lexiconNames.map(value => value),
        outputFormat,
        sampleRate.map(value => value),
        speechMarkTypes.map(value => value),
        text,
        textType.map(value => value),
        voiceId
      )
    def engine: Option[zio.aws.polly.model.Engine]
    def languageCode: Option[zio.aws.polly.model.LanguageCode]
    def lexiconNames: Option[List[LexiconName]]
    def outputFormat: zio.aws.polly.model.OutputFormat
    def sampleRate: Option[SampleRate]
    def speechMarkTypes: Option[List[zio.aws.polly.model.SpeechMarkType]]
    def text: Text
    def textType: Option[zio.aws.polly.model.TextType]
    def voiceId: zio.aws.polly.model.VoiceId
    def getEngine: ZIO[Any, AwsError, zio.aws.polly.model.Engine] =
      AwsError.unwrapOptionField("engine", engine)
    def getLanguageCode: ZIO[Any, AwsError, zio.aws.polly.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getLexiconNames: ZIO[Any, AwsError, List[LexiconName]] =
      AwsError.unwrapOptionField("lexiconNames", lexiconNames)
    def getOutputFormat: ZIO[Any, Nothing, zio.aws.polly.model.OutputFormat] =
      ZIO.succeed(outputFormat)
    def getSampleRate: ZIO[Any, AwsError, SampleRate] =
      AwsError.unwrapOptionField("sampleRate", sampleRate)
    def getSpeechMarkTypes
        : ZIO[Any, AwsError, List[zio.aws.polly.model.SpeechMarkType]] =
      AwsError.unwrapOptionField("speechMarkTypes", speechMarkTypes)
    def getText: ZIO[Any, Nothing, Text] = ZIO.succeed(text)
    def getTextType: ZIO[Any, AwsError, zio.aws.polly.model.TextType] =
      AwsError.unwrapOptionField("textType", textType)
    def getVoiceId: ZIO[Any, Nothing, zio.aws.polly.model.VoiceId] =
      ZIO.succeed(voiceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.polly.model.SynthesizeSpeechRequest
  ) extends zio.aws.polly.model.SynthesizeSpeechRequest.ReadOnly {
    override val engine: Option[zio.aws.polly.model.Engine] = scala
      .Option(impl.engine())
      .map(value => zio.aws.polly.model.Engine.wrap(value))
    override val languageCode: Option[zio.aws.polly.model.LanguageCode] = scala
      .Option(impl.languageCode())
      .map(value => zio.aws.polly.model.LanguageCode.wrap(value))
    override val lexiconNames: Option[List[LexiconName]] = scala
      .Option(impl.lexiconNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.polly.model.primitives.LexiconName(item)
        }.toList
      )
    override val outputFormat: zio.aws.polly.model.OutputFormat =
      zio.aws.polly.model.OutputFormat.wrap(impl.outputFormat())
    override val sampleRate: Option[SampleRate] = scala
      .Option(impl.sampleRate())
      .map(value => zio.aws.polly.model.primitives.SampleRate(value))
    override val speechMarkTypes
        : Option[List[zio.aws.polly.model.SpeechMarkType]] = scala
      .Option(impl.speechMarkTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.polly.model.SpeechMarkType.wrap(item)
        }.toList
      )
    override val text: Text = zio.aws.polly.model.primitives.Text(impl.text())
    override val textType: Option[zio.aws.polly.model.TextType] = scala
      .Option(impl.textType())
      .map(value => zio.aws.polly.model.TextType.wrap(value))
    override val voiceId: zio.aws.polly.model.VoiceId =
      zio.aws.polly.model.VoiceId.wrap(impl.voiceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.polly.model.SynthesizeSpeechRequest
  ): zio.aws.polly.model.SynthesizeSpeechRequest.ReadOnly = new Wrapper(impl)
}
