package zio.aws.polly.model
import scala.jdk.CollectionConverters._
sealed trait TaskStatus {
  def unwrap: software.amazon.awssdk.services.polly.model.TaskStatus
}
object TaskStatus {
  def wrap(
      value: software.amazon.awssdk.services.polly.model.TaskStatus
  ): zio.aws.polly.model.TaskStatus = value match {
    case software.amazon.awssdk.services.polly.model.TaskStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.polly.model.TaskStatus.SCHEDULED =>
      val r = scheduled
      r
    case software.amazon.awssdk.services.polly.model.TaskStatus.IN_PROGRESS =>
      val r = inProgress
      r
    case software.amazon.awssdk.services.polly.model.TaskStatus.COMPLETED =>
      val r = completed
      r
    case software.amazon.awssdk.services.polly.model.TaskStatus.FAILED =>
      val r = failed
      r
  }
  case object unknownToSdkVersion extends zio.aws.polly.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.TaskStatus =
      software.amazon.awssdk.services.polly.model.TaskStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object scheduled extends zio.aws.polly.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.TaskStatus =
      software.amazon.awssdk.services.polly.model.TaskStatus.SCHEDULED
  }
  case object inProgress extends zio.aws.polly.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.TaskStatus =
      software.amazon.awssdk.services.polly.model.TaskStatus.IN_PROGRESS
  }
  case object completed extends zio.aws.polly.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.TaskStatus =
      software.amazon.awssdk.services.polly.model.TaskStatus.COMPLETED
  }
  case object failed extends zio.aws.polly.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.TaskStatus =
      software.amazon.awssdk.services.polly.model.TaskStatus.FAILED
  }
}
