package zio.aws.polly.model
import zio.aws.polly.model.primitives.{VoiceName, LanguageName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Voice(
    gender: Option[zio.aws.polly.model.Gender] = None,
    id: Option[zio.aws.polly.model.VoiceId] = None,
    languageCode: Option[zio.aws.polly.model.LanguageCode] = None,
    languageName: Option[LanguageName] = None,
    name: Option[VoiceName] = None,
    additionalLanguageCodes: Option[
      Iterable[zio.aws.polly.model.LanguageCode]
    ] = None,
    supportedEngines: Option[Iterable[zio.aws.polly.model.Engine]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.polly.model.Voice = {
    import Voice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.polly.model.Voice
      .builder()
      .optionallyWith(gender.map(value => value.unwrap))(_.gender)
      .optionallyWith(id.map(value => value.unwrap))(_.id)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        languageName.map(value => LanguageName.unwrap(value): java.lang.String)
      )(_.languageName)
      .optionallyWith(
        name.map(value => VoiceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        additionalLanguageCodes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.additionalLanguageCodesWithStrings)
      .optionallyWith(
        supportedEngines.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedEnginesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.polly.model.Voice.ReadOnly =
    zio.aws.polly.model.Voice.wrap(buildAwsValue())
}
object Voice {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.polly.model.Voice] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.polly.model.Voice = zio.aws.polly.model.Voice(
      gender.map(value => value),
      id.map(value => value),
      languageCode.map(value => value),
      languageName.map(value => value),
      name.map(value => value),
      additionalLanguageCodes.map(value => value),
      supportedEngines.map(value => value)
    )
    def gender: Option[zio.aws.polly.model.Gender]
    def id: Option[zio.aws.polly.model.VoiceId]
    def languageCode: Option[zio.aws.polly.model.LanguageCode]
    def languageName: Option[LanguageName]
    def name: Option[VoiceName]
    def additionalLanguageCodes: Option[List[zio.aws.polly.model.LanguageCode]]
    def supportedEngines: Option[List[zio.aws.polly.model.Engine]]
    def getGender: ZIO[Any, AwsError, zio.aws.polly.model.Gender] =
      AwsError.unwrapOptionField("gender", gender)
    def getId: ZIO[Any, AwsError, zio.aws.polly.model.VoiceId] =
      AwsError.unwrapOptionField("id", id)
    def getLanguageCode: ZIO[Any, AwsError, zio.aws.polly.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getLanguageName: ZIO[Any, AwsError, LanguageName] =
      AwsError.unwrapOptionField("languageName", languageName)
    def getName: ZIO[Any, AwsError, VoiceName] =
      AwsError.unwrapOptionField("name", name)
    def getAdditionalLanguageCodes
        : ZIO[Any, AwsError, List[zio.aws.polly.model.LanguageCode]] = AwsError
      .unwrapOptionField("additionalLanguageCodes", additionalLanguageCodes)
    def getSupportedEngines
        : ZIO[Any, AwsError, List[zio.aws.polly.model.Engine]] =
      AwsError.unwrapOptionField("supportedEngines", supportedEngines)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.polly.model.Voice
  ) extends zio.aws.polly.model.Voice.ReadOnly {
    override val gender: Option[zio.aws.polly.model.Gender] = scala
      .Option(impl.gender())
      .map(value => zio.aws.polly.model.Gender.wrap(value))
    override val id: Option[zio.aws.polly.model.VoiceId] = scala
      .Option(impl.id())
      .map(value => zio.aws.polly.model.VoiceId.wrap(value))
    override val languageCode: Option[zio.aws.polly.model.LanguageCode] = scala
      .Option(impl.languageCode())
      .map(value => zio.aws.polly.model.LanguageCode.wrap(value))
    override val languageName: Option[LanguageName] = scala
      .Option(impl.languageName())
      .map(value => zio.aws.polly.model.primitives.LanguageName(value))
    override val name: Option[VoiceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.polly.model.primitives.VoiceName(value))
    override val additionalLanguageCodes
        : Option[List[zio.aws.polly.model.LanguageCode]] = scala
      .Option(impl.additionalLanguageCodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.polly.model.LanguageCode.wrap(item)
        }.toList
      )
    override val supportedEngines: Option[List[zio.aws.polly.model.Engine]] =
      scala
        .Option(impl.supportedEngines())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.polly.model.Engine.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.polly.model.Voice
  ): zio.aws.polly.model.Voice.ReadOnly = new Wrapper(impl)
}
