package zio.aws.polly
import zio.aws.polly.model.primitives.MaxResults.Type
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
import zio.aws.polly.model.primitives.LexiconName
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object Alphabet extends Subtype[String]
    type Alphabet = zio.aws.polly.model.primitives.Alphabet.Type
    object AudioStream extends Subtype[Chunk[Byte]]
    type AudioStream = zio.aws.polly.model.primitives.AudioStream.Type
    object ContentType extends Subtype[String]
    type ContentType = zio.aws.polly.model.primitives.ContentType.Type
    object DateTime extends Subtype[Instant]
    type DateTime = zio.aws.polly.model.primitives.DateTime.Type
    object IncludeAdditionalLanguageCodes extends Subtype[Boolean]
    type IncludeAdditionalLanguageCodes =
      zio.aws.polly.model.primitives.IncludeAdditionalLanguageCodes.Type
    object LanguageName extends Subtype[String]
    type LanguageName = zio.aws.polly.model.primitives.LanguageName.Type
    object LastModified extends Subtype[Instant]
    type LastModified = zio.aws.polly.model.primitives.LastModified.Type
    object LexemesCount extends Subtype[Int]
    type LexemesCount = zio.aws.polly.model.primitives.LexemesCount.Type
    object LexiconArn extends Subtype[String]
    type LexiconArn = zio.aws.polly.model.primitives.LexiconArn.Type
    object LexiconContent extends Subtype[String]
    type LexiconContent = zio.aws.polly.model.primitives.LexiconContent.Type
    object LexiconName extends Subtype[String]
    type LexiconName = zio.aws.polly.model.primitives.LexiconName.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.polly.model.primitives.MaxResults.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.polly.model.primitives.NextToken.Type
    object OutputS3BucketName extends Subtype[String]
    type OutputS3BucketName =
      zio.aws.polly.model.primitives.OutputS3BucketName.Type
    object OutputS3KeyPrefix extends Subtype[String]
    type OutputS3KeyPrefix =
      zio.aws.polly.model.primitives.OutputS3KeyPrefix.Type
    object OutputUri extends Subtype[String]
    type OutputUri = zio.aws.polly.model.primitives.OutputUri.Type
    object RequestCharacters extends Subtype[Int]
    type RequestCharacters =
      zio.aws.polly.model.primitives.RequestCharacters.Type
    object SampleRate extends Subtype[String]
    type SampleRate = zio.aws.polly.model.primitives.SampleRate.Type
    object Size extends Subtype[Int]
    type Size = zio.aws.polly.model.primitives.Size.Type
    object SnsTopicArn extends Subtype[String]
    type SnsTopicArn = zio.aws.polly.model.primitives.SnsTopicArn.Type
    object TaskId extends Subtype[String]
    type TaskId = zio.aws.polly.model.primitives.TaskId.Type
    object TaskStatusReason extends Subtype[String]
    type TaskStatusReason = zio.aws.polly.model.primitives.TaskStatusReason.Type
    object Text extends Subtype[String]
    type Text = zio.aws.polly.model.primitives.Text.Type
    object VoiceName extends Subtype[String]
    type VoiceName = zio.aws.polly.model.primitives.VoiceName.Type
  }
  type EngineList = List[zio.aws.polly.model.Engine]
  type LanguageCodeList = List[zio.aws.polly.model.LanguageCode]
  type LexiconDescriptionList = List[zio.aws.polly.model.LexiconDescription]
  type LexiconNameList = List[LexiconName]
  type SpeechMarkTypeList = List[zio.aws.polly.model.SpeechMarkType]
  type SynthesisTasks = List[zio.aws.polly.model.SynthesisTask]
  type VoiceList = List[zio.aws.polly.model.Voice]
}
