package zio.aws.polly
import software.amazon.awssdk.services.polly.{
  PollyAsyncClientBuilder,
  PollyAsyncClient
}
import zio.aws.polly.model.ListLexiconsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.polly.model.{
  Voice,
  SynthesizeSpeechResponse,
  SynthesisTask,
  DeleteLexiconResponse,
  PutLexiconResponse,
  ListLexiconsRequest,
  LexiconDescription,
  DescribeVoicesResponse,
  StartSpeechSynthesisTaskResponse,
  DeleteLexiconRequest,
  StartSpeechSynthesisTaskRequest,
  ListSpeechSynthesisTasksRequest,
  GetSpeechSynthesisTaskResponse,
  GetSpeechSynthesisTaskRequest,
  GetLexiconResponse,
  DescribeVoicesRequest,
  ListSpeechSynthesisTasksResponse,
  SynthesizeSpeechRequest,
  GetLexiconRequest,
  PutLexiconRequest,
  ListLexiconsResponse
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, Task, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Polly extends AspectSupport[Polly] {
  val api: PollyAsyncClient
  def listLexicons(
      request: zio.aws.polly.model.ListLexiconsRequest
  ): ZStream[Any, AwsError, zio.aws.polly.model.LexiconDescription.ReadOnly]
  def listLexiconsPaginated(
      request: zio.aws.polly.model.ListLexiconsRequest
  ): IO[AwsError, ReadOnly]
  def putLexicon(
      request: zio.aws.polly.model.PutLexiconRequest
  ): IO[AwsError, zio.aws.polly.model.PutLexiconResponse.ReadOnly]
  def listSpeechSynthesisTasks(
      request: zio.aws.polly.model.ListSpeechSynthesisTasksRequest
  ): ZStream[Any, AwsError, zio.aws.polly.model.SynthesisTask.ReadOnly]
  def listSpeechSynthesisTasksPaginated(
      request: zio.aws.polly.model.ListSpeechSynthesisTasksRequest
  ): IO[AwsError, zio.aws.polly.model.ListSpeechSynthesisTasksResponse.ReadOnly]
  def getLexicon(
      request: zio.aws.polly.model.GetLexiconRequest
  ): IO[AwsError, zio.aws.polly.model.GetLexiconResponse.ReadOnly]
  def startSpeechSynthesisTask(
      request: zio.aws.polly.model.StartSpeechSynthesisTaskRequest
  ): IO[AwsError, zio.aws.polly.model.StartSpeechSynthesisTaskResponse.ReadOnly]
  def getSpeechSynthesisTask(
      request: zio.aws.polly.model.GetSpeechSynthesisTaskRequest
  ): IO[AwsError, zio.aws.polly.model.GetSpeechSynthesisTaskResponse.ReadOnly]
  def synthesizeSpeech(
      request: zio.aws.polly.model.SynthesizeSpeechRequest
  ): IO[AwsError, StreamingOutputResult[
    Any,
    zio.aws.polly.model.SynthesizeSpeechResponse.ReadOnly,
    Byte
  ]]
  def deleteLexicon(
      request: zio.aws.polly.model.DeleteLexiconRequest
  ): IO[AwsError, zio.aws.polly.model.DeleteLexiconResponse.ReadOnly]
  def describeVoices(
      request: zio.aws.polly.model.DescribeVoicesRequest
  ): ZStream[Any, AwsError, zio.aws.polly.model.Voice.ReadOnly]
  def describeVoicesPaginated(
      request: zio.aws.polly.model.DescribeVoicesRequest
  ): IO[AwsError, zio.aws.polly.model.DescribeVoicesResponse.ReadOnly]
}
object Polly {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Polly] = customized(identity)
  def customized(
      customization: PollyAsyncClientBuilder => PollyAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Polly] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: PollyAsyncClientBuilder => PollyAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Polly] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = PollyAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[PollyAsyncClient, PollyAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[PollyAsyncClient, PollyAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new PollyImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class PollyImpl[R](
      override val api: PollyAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Polly
      with AwsServiceBase[R] {
    override val serviceName: String = "Polly"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): PollyImpl[R1] = new PollyImpl(api, newAspect, r)
    def listLexicons(
        request: zio.aws.polly.model.ListLexiconsRequest
    ): ZStream[Any, AwsError, zio.aws.polly.model.LexiconDescription.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListLexiconsRequest,
        ListLexiconsResponse,
        LexiconDescription
      ](
        "listLexicons",
        api.listLexicons,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.lexicons().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.polly.model.LexiconDescription.wrap(item))
        .provideEnvironment(r)
    def listLexiconsPaginated(
        request: zio.aws.polly.model.ListLexiconsRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[ListLexiconsRequest, ListLexiconsResponse](
        "listLexicons",
        api.listLexicons
      )(request.buildAwsValue())
        .map(zio.aws.polly.model.ListLexiconsResponse.wrap)
        .provideEnvironment(r)
    def putLexicon(
        request: zio.aws.polly.model.PutLexiconRequest
    ): IO[AwsError, zio.aws.polly.model.PutLexiconResponse.ReadOnly] =
      asyncRequestResponse[PutLexiconRequest, PutLexiconResponse](
        "putLexicon",
        api.putLexicon
      )(request.buildAwsValue())
        .map(zio.aws.polly.model.PutLexiconResponse.wrap)
        .provideEnvironment(r)
    def listSpeechSynthesisTasks(
        request: zio.aws.polly.model.ListSpeechSynthesisTasksRequest
    ): ZStream[Any, AwsError, zio.aws.polly.model.SynthesisTask.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListSpeechSynthesisTasksRequest,
        ListSpeechSynthesisTasksResponse,
        SynthesisTask
      ](
        "listSpeechSynthesisTasks",
        api.listSpeechSynthesisTasks,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.synthesisTasks().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.polly.model.SynthesisTask.wrap(item))
        .provideEnvironment(r)
    def listSpeechSynthesisTasksPaginated(
        request: zio.aws.polly.model.ListSpeechSynthesisTasksRequest
    ): IO[
      AwsError,
      zio.aws.polly.model.ListSpeechSynthesisTasksResponse.ReadOnly
    ] = asyncRequestResponse[
      ListSpeechSynthesisTasksRequest,
      ListSpeechSynthesisTasksResponse
    ]("listSpeechSynthesisTasks", api.listSpeechSynthesisTasks)(
      request.buildAwsValue()
    ).map(zio.aws.polly.model.ListSpeechSynthesisTasksResponse.wrap)
      .provideEnvironment(r)
    def getLexicon(
        request: zio.aws.polly.model.GetLexiconRequest
    ): IO[AwsError, zio.aws.polly.model.GetLexiconResponse.ReadOnly] =
      asyncRequestResponse[GetLexiconRequest, GetLexiconResponse](
        "getLexicon",
        api.getLexicon
      )(request.buildAwsValue())
        .map(zio.aws.polly.model.GetLexiconResponse.wrap)
        .provideEnvironment(r)
    def startSpeechSynthesisTask(
        request: zio.aws.polly.model.StartSpeechSynthesisTaskRequest
    ): IO[
      AwsError,
      zio.aws.polly.model.StartSpeechSynthesisTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      StartSpeechSynthesisTaskRequest,
      StartSpeechSynthesisTaskResponse
    ]("startSpeechSynthesisTask", api.startSpeechSynthesisTask)(
      request.buildAwsValue()
    ).map(zio.aws.polly.model.StartSpeechSynthesisTaskResponse.wrap)
      .provideEnvironment(r)
    def getSpeechSynthesisTask(
        request: zio.aws.polly.model.GetSpeechSynthesisTaskRequest
    ): IO[
      AwsError,
      zio.aws.polly.model.GetSpeechSynthesisTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      GetSpeechSynthesisTaskRequest,
      GetSpeechSynthesisTaskResponse
    ]("getSpeechSynthesisTask", api.getSpeechSynthesisTask)(
      request.buildAwsValue()
    ).map(zio.aws.polly.model.GetSpeechSynthesisTaskResponse.wrap)
      .provideEnvironment(r)
    def synthesizeSpeech(
        request: zio.aws.polly.model.SynthesizeSpeechRequest
    ): IO[AwsError, StreamingOutputResult[
      Any,
      zio.aws.polly.model.SynthesizeSpeechResponse.ReadOnly,
      Byte
    ]] = asyncRequestOutputStream[
      SynthesizeSpeechRequest,
      SynthesizeSpeechResponse
    ](
      "synthesizeSpeech",
      api.synthesizeSpeech[Task[
        StreamingOutputResult[R, SynthesizeSpeechResponse, Byte]
      ]]
    )(request.buildAwsValue())
      .map(
        _.mapResponse(zio.aws.polly.model.SynthesizeSpeechResponse.wrap)
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def deleteLexicon(
        request: zio.aws.polly.model.DeleteLexiconRequest
    ): IO[AwsError, zio.aws.polly.model.DeleteLexiconResponse.ReadOnly] =
      asyncRequestResponse[DeleteLexiconRequest, DeleteLexiconResponse](
        "deleteLexicon",
        api.deleteLexicon
      )(request.buildAwsValue())
        .map(zio.aws.polly.model.DeleteLexiconResponse.wrap)
        .provideEnvironment(r)
    def describeVoices(
        request: zio.aws.polly.model.DescribeVoicesRequest
    ): ZStream[Any, AwsError, zio.aws.polly.model.Voice.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeVoicesRequest,
        DescribeVoicesResponse,
        Voice
      ](
        "describeVoices",
        api.describeVoices,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.voices().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.polly.model.Voice.wrap(item))
        .provideEnvironment(r)
    def describeVoicesPaginated(
        request: zio.aws.polly.model.DescribeVoicesRequest
    ): IO[AwsError, zio.aws.polly.model.DescribeVoicesResponse.ReadOnly] =
      asyncRequestResponse[DescribeVoicesRequest, DescribeVoicesResponse](
        "describeVoices",
        api.describeVoices
      )(request.buildAwsValue())
        .map(zio.aws.polly.model.DescribeVoicesResponse.wrap)
        .provideEnvironment(r)
  }
  def listLexicons(request: zio.aws.polly.model.ListLexiconsRequest): ZStream[
    zio.aws.polly.Polly,
    AwsError,
    zio.aws.polly.model.LexiconDescription.ReadOnly
  ] = ZStream.serviceWithStream(_.listLexicons(request))
  def listLexiconsPaginated(
      request: zio.aws.polly.model.ListLexiconsRequest
  ): ZIO[zio.aws.polly.Polly, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listLexiconsPaginated(request))
  def putLexicon(request: zio.aws.polly.model.PutLexiconRequest): ZIO[
    zio.aws.polly.Polly,
    AwsError,
    zio.aws.polly.model.PutLexiconResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putLexicon(request))
  def listSpeechSynthesisTasks(
      request: zio.aws.polly.model.ListSpeechSynthesisTasksRequest
  ): ZStream[
    zio.aws.polly.Polly,
    AwsError,
    zio.aws.polly.model.SynthesisTask.ReadOnly
  ] = ZStream.serviceWithStream(_.listSpeechSynthesisTasks(request))
  def listSpeechSynthesisTasksPaginated(
      request: zio.aws.polly.model.ListSpeechSynthesisTasksRequest
  ): ZIO[
    zio.aws.polly.Polly,
    AwsError,
    zio.aws.polly.model.ListSpeechSynthesisTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSpeechSynthesisTasksPaginated(request))
  def getLexicon(request: zio.aws.polly.model.GetLexiconRequest): ZIO[
    zio.aws.polly.Polly,
    AwsError,
    zio.aws.polly.model.GetLexiconResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLexicon(request))
  def startSpeechSynthesisTask(
      request: zio.aws.polly.model.StartSpeechSynthesisTaskRequest
  ): ZIO[
    zio.aws.polly.Polly,
    AwsError,
    zio.aws.polly.model.StartSpeechSynthesisTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startSpeechSynthesisTask(request))
  def getSpeechSynthesisTask(
      request: zio.aws.polly.model.GetSpeechSynthesisTaskRequest
  ): ZIO[
    zio.aws.polly.Polly,
    AwsError,
    zio.aws.polly.model.GetSpeechSynthesisTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSpeechSynthesisTask(request))
  def synthesizeSpeech(
      request: zio.aws.polly.model.SynthesizeSpeechRequest
  ): ZIO[zio.aws.polly.Polly, AwsError, StreamingOutputResult[
    Any,
    zio.aws.polly.model.SynthesizeSpeechResponse.ReadOnly,
    Byte
  ]] = ZIO.serviceWithZIO(_.synthesizeSpeech(request))
  def deleteLexicon(request: zio.aws.polly.model.DeleteLexiconRequest): ZIO[
    zio.aws.polly.Polly,
    AwsError,
    zio.aws.polly.model.DeleteLexiconResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLexicon(request))
  def describeVoices(
      request: zio.aws.polly.model.DescribeVoicesRequest
  ): ZStream[
    zio.aws.polly.Polly,
    AwsError,
    zio.aws.polly.model.Voice.ReadOnly
  ] = ZStream.serviceWithStream(_.describeVoices(request))
  def describeVoicesPaginated(
      request: zio.aws.polly.model.DescribeVoicesRequest
  ): ZIO[
    zio.aws.polly.Polly,
    AwsError,
    zio.aws.polly.model.DescribeVoicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVoicesPaginated(request))
}
