package zio.aws.polly.model
import zio.aws.polly.model.primitives.{
  NextToken,
  IncludeAdditionalLanguageCodes
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVoicesRequest(
    engine: Optional[zio.aws.polly.model.Engine] = Optional.Absent,
    languageCode: Optional[zio.aws.polly.model.LanguageCode] = Optional.Absent,
    includeAdditionalLanguageCodes: Optional[IncludeAdditionalLanguageCodes] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.polly.model.DescribeVoicesRequest = {
    import DescribeVoicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.polly.model.DescribeVoicesRequest
      .builder()
      .optionallyWith(engine.map(value => value.unwrap))(_.engine)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        includeAdditionalLanguageCodes.map(value =>
          IncludeAdditionalLanguageCodes.unwrap(value): java.lang.Boolean
        )
      )(_.includeAdditionalLanguageCodes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.polly.model.DescribeVoicesRequest.ReadOnly =
    zio.aws.polly.model.DescribeVoicesRequest.wrap(buildAwsValue())
}
object DescribeVoicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.polly.model.DescribeVoicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.polly.model.DescribeVoicesRequest =
      zio.aws.polly.model.DescribeVoicesRequest(
        engine.map(value => value),
        languageCode.map(value => value),
        includeAdditionalLanguageCodes.map(value => value),
        nextToken.map(value => value)
      )
    def engine: Optional[zio.aws.polly.model.Engine]
    def languageCode: Optional[zio.aws.polly.model.LanguageCode]
    def includeAdditionalLanguageCodes: Optional[IncludeAdditionalLanguageCodes]
    def nextToken: Optional[NextToken]
    def getEngine: ZIO[Any, AwsError, zio.aws.polly.model.Engine] =
      AwsError.unwrapOptionField("engine", engine)
    def getLanguageCode: ZIO[Any, AwsError, zio.aws.polly.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getIncludeAdditionalLanguageCodes
        : ZIO[Any, AwsError, IncludeAdditionalLanguageCodes] =
      AwsError.unwrapOptionField(
        "includeAdditionalLanguageCodes",
        includeAdditionalLanguageCodes
      )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.polly.model.DescribeVoicesRequest
  ) extends zio.aws.polly.model.DescribeVoicesRequest.ReadOnly {
    override val engine: Optional[zio.aws.polly.model.Engine] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engine())
        .map(value => zio.aws.polly.model.Engine.wrap(value))
    override val languageCode: Optional[zio.aws.polly.model.LanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value => zio.aws.polly.model.LanguageCode.wrap(value))
    override val includeAdditionalLanguageCodes
        : Optional[IncludeAdditionalLanguageCodes] = zio.aws.core.internal
      .optionalFromNullable(impl.includeAdditionalLanguageCodes())
      .map(value =>
        zio.aws.polly.model.primitives.IncludeAdditionalLanguageCodes(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.polly.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.polly.model.DescribeVoicesRequest
  ): zio.aws.polly.model.DescribeVoicesRequest.ReadOnly = new Wrapper(impl)
}
