package zio.aws.polly.model
import zio.aws.polly.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVoicesResponse(
    voices: Optional[Iterable[zio.aws.polly.model.Voice]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.polly.model.DescribeVoicesResponse = {
    import DescribeVoicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.polly.model.DescribeVoicesResponse
      .builder()
      .optionallyWith(
        voices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.voices)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.polly.model.DescribeVoicesResponse.ReadOnly =
    zio.aws.polly.model.DescribeVoicesResponse.wrap(buildAwsValue())
}
object DescribeVoicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.polly.model.DescribeVoicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.polly.model.DescribeVoicesResponse =
      zio.aws.polly.model.DescribeVoicesResponse(
        voices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def voices: Optional[List[zio.aws.polly.model.Voice.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getVoices
        : ZIO[Any, AwsError, List[zio.aws.polly.model.Voice.ReadOnly]] =
      AwsError.unwrapOptionField("voices", voices)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.polly.model.DescribeVoicesResponse
  ) extends zio.aws.polly.model.DescribeVoicesResponse.ReadOnly {
    override val voices: Optional[List[zio.aws.polly.model.Voice.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.polly.model.Voice.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.polly.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.polly.model.DescribeVoicesResponse
  ): zio.aws.polly.model.DescribeVoicesResponse.ReadOnly = new Wrapper(impl)
}
