package zio.aws.polly.model
import scala.jdk.CollectionConverters._
sealed trait Engine {
  def unwrap: software.amazon.awssdk.services.polly.model.Engine
}
object Engine {
  def wrap(
      value: software.amazon.awssdk.services.polly.model.Engine
  ): zio.aws.polly.model.Engine = value match {
    case software.amazon.awssdk.services.polly.model.Engine.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.polly.model.Engine.STANDARD =>
      val r = standard
      r
    case software.amazon.awssdk.services.polly.model.Engine.NEURAL =>
      val r = neural
      r
  }
  case object unknownToSdkVersion extends zio.aws.polly.model.Engine {
    override def unwrap: software.amazon.awssdk.services.polly.model.Engine =
      software.amazon.awssdk.services.polly.model.Engine.UNKNOWN_TO_SDK_VERSION
  }
  case object standard extends zio.aws.polly.model.Engine {
    override def unwrap: software.amazon.awssdk.services.polly.model.Engine =
      software.amazon.awssdk.services.polly.model.Engine.STANDARD
  }
  case object neural extends zio.aws.polly.model.Engine {
    override def unwrap: software.amazon.awssdk.services.polly.model.Engine =
      software.amazon.awssdk.services.polly.model.Engine.NEURAL
  }
}
