package zio.aws.polly.model
import scala.jdk.CollectionConverters._
sealed trait Gender {
  def unwrap: software.amazon.awssdk.services.polly.model.Gender
}
object Gender {
  def wrap(
      value: software.amazon.awssdk.services.polly.model.Gender
  ): zio.aws.polly.model.Gender = value match {
    case software.amazon.awssdk.services.polly.model.Gender.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.polly.model.Gender.FEMALE =>
      val r = Female
      r
    case software.amazon.awssdk.services.polly.model.Gender.MALE =>
      val r = Male
      r
  }
  case object unknownToSdkVersion extends zio.aws.polly.model.Gender {
    override def unwrap: software.amazon.awssdk.services.polly.model.Gender =
      software.amazon.awssdk.services.polly.model.Gender.UNKNOWN_TO_SDK_VERSION
  }
  case object Female extends zio.aws.polly.model.Gender {
    override def unwrap: software.amazon.awssdk.services.polly.model.Gender =
      software.amazon.awssdk.services.polly.model.Gender.FEMALE
  }
  case object Male extends zio.aws.polly.model.Gender {
    override def unwrap: software.amazon.awssdk.services.polly.model.Gender =
      software.amazon.awssdk.services.polly.model.Gender.MALE
  }
}
