package zio.aws.polly.model
import zio.aws.polly.model.primitives.LexiconName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetLexiconRequest(name: LexiconName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.polly.model.GetLexiconRequest = {
    import GetLexiconRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.polly.model.GetLexiconRequest
      .builder()
      .name(LexiconName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.polly.model.GetLexiconRequest.ReadOnly =
    zio.aws.polly.model.GetLexiconRequest.wrap(buildAwsValue())
}
object GetLexiconRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.polly.model.GetLexiconRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.polly.model.GetLexiconRequest =
      zio.aws.polly.model.GetLexiconRequest(name)
    def name: LexiconName
    def getName: ZIO[Any, Nothing, LexiconName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.polly.model.GetLexiconRequest
  ) extends zio.aws.polly.model.GetLexiconRequest.ReadOnly {
    override val name: LexiconName =
      zio.aws.polly.model.primitives.LexiconName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.polly.model.GetLexiconRequest
  ): zio.aws.polly.model.GetLexiconRequest.ReadOnly = new Wrapper(impl)
}
