package zio.aws.polly.model
import scala.jdk.CollectionConverters._
sealed trait LanguageCode {
  def unwrap: software.amazon.awssdk.services.polly.model.LanguageCode
}
object LanguageCode {
  def wrap(
      value: software.amazon.awssdk.services.polly.model.LanguageCode
  ): zio.aws.polly.model.LanguageCode = value match {
    case software.amazon.awssdk.services.polly.model.LanguageCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.ARB =>
      val r = arb
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.CMN_CN =>
      val r = `cmn-CN`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.CY_GB =>
      val r = `cy-GB`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.DA_DK =>
      val r = `da-DK`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.DE_DE =>
      val r = `de-DE`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.EN_AU =>
      val r = `en-AU`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.EN_GB =>
      val r = `en-GB`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.EN_GB_WLS =>
      val r = `en-GB-WLS`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.EN_IN =>
      val r = `en-IN`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.EN_US =>
      val r = `en-US`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.ES_ES =>
      val r = `es-ES`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.ES_MX =>
      val r = `es-MX`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.ES_US =>
      val r = `es-US`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.FR_CA =>
      val r = `fr-CA`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.FR_FR =>
      val r = `fr-FR`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.IS_IS =>
      val r = `is-IS`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.IT_IT =>
      val r = `it-IT`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.JA_JP =>
      val r = `ja-JP`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.HI_IN =>
      val r = `hi-IN`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.KO_KR =>
      val r = `ko-KR`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.NB_NO =>
      val r = `nb-NO`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.NL_NL =>
      val r = `nl-NL`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.PL_PL =>
      val r = `pl-PL`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.PT_BR =>
      val r = `pt-BR`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.PT_PT =>
      val r = `pt-PT`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.RO_RO =>
      val r = `ro-RO`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.RU_RU =>
      val r = `ru-RU`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.SV_SE =>
      val r = `sv-SE`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.TR_TR =>
      val r = `tr-TR`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.EN_NZ =>
      val r = `en-NZ`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.EN_ZA =>
      val r = `en-ZA`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.CA_ES =>
      val r = `ca-ES`
      r
    case software.amazon.awssdk.services.polly.model.LanguageCode.DE_AT =>
      val r = `de-AT`
      r
  }
  case object unknownToSdkVersion extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.UNKNOWN_TO_SDK_VERSION
  }
  case object arb extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.ARB
  }
  case object `cmn-CN` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.CMN_CN
  }
  case object `cy-GB` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.CY_GB
  }
  case object `da-DK` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.DA_DK
  }
  case object `de-DE` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.DE_DE
  }
  case object `en-AU` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.EN_AU
  }
  case object `en-GB` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.EN_GB
  }
  case object `en-GB-WLS` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.EN_GB_WLS
  }
  case object `en-IN` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.EN_IN
  }
  case object `en-US` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.EN_US
  }
  case object `es-ES` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.ES_ES
  }
  case object `es-MX` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.ES_MX
  }
  case object `es-US` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.ES_US
  }
  case object `fr-CA` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.FR_CA
  }
  case object `fr-FR` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.FR_FR
  }
  case object `is-IS` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.IS_IS
  }
  case object `it-IT` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.IT_IT
  }
  case object `ja-JP` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.JA_JP
  }
  case object `hi-IN` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.HI_IN
  }
  case object `ko-KR` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.KO_KR
  }
  case object `nb-NO` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.NB_NO
  }
  case object `nl-NL` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.NL_NL
  }
  case object `pl-PL` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.PL_PL
  }
  case object `pt-BR` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.PT_BR
  }
  case object `pt-PT` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.PT_PT
  }
  case object `ro-RO` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.RO_RO
  }
  case object `ru-RU` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.RU_RU
  }
  case object `sv-SE` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.SV_SE
  }
  case object `tr-TR` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.TR_TR
  }
  case object `en-NZ` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.EN_NZ
  }
  case object `en-ZA` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.EN_ZA
  }
  case object `ca-ES` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.CA_ES
  }
  case object `de-AT` extends zio.aws.polly.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.polly.model.LanguageCode =
      software.amazon.awssdk.services.polly.model.LanguageCode.DE_AT
  }
}
