package zio.aws.polly.model
import zio.aws.polly.model.primitives.{LexiconName, LexiconContent}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Lexicon(
    content: Optional[LexiconContent] = Optional.Absent,
    name: Optional[LexiconName] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.polly.model.Lexicon = {
    import Lexicon.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.polly.model.Lexicon
      .builder()
      .optionallyWith(
        content.map(value => LexiconContent.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(
        name.map(value => LexiconName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.polly.model.Lexicon.ReadOnly =
    zio.aws.polly.model.Lexicon.wrap(buildAwsValue())
}
object Lexicon {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.polly.model.Lexicon] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.polly.model.Lexicon = zio.aws.polly.model
      .Lexicon(content.map(value => value), name.map(value => value))
    def content: Optional[LexiconContent]
    def name: Optional[LexiconName]
    def getContent: ZIO[Any, AwsError, LexiconContent] =
      AwsError.unwrapOptionField("content", content)
    def getName: ZIO[Any, AwsError, LexiconName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.polly.model.Lexicon
  ) extends zio.aws.polly.model.Lexicon.ReadOnly {
    override val content: Optional[LexiconContent] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => zio.aws.polly.model.primitives.LexiconContent(value))
    override val name: Optional[LexiconName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.polly.model.primitives.LexiconName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.polly.model.Lexicon
  ): zio.aws.polly.model.Lexicon.ReadOnly = new Wrapper(impl)
}
