package zio.aws.polly.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.polly.model.primitives.{
  Alphabet,
  LastModified,
  LexemesCount,
  LexiconArn,
  Size
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LexiconAttributes(
    alphabet: Optional[Alphabet] = Optional.Absent,
    languageCode: Optional[zio.aws.polly.model.LanguageCode] = Optional.Absent,
    lastModified: Optional[LastModified] = Optional.Absent,
    lexiconArn: Optional[LexiconArn] = Optional.Absent,
    lexemesCount: Optional[LexemesCount] = Optional.Absent,
    size: Optional[Size] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.polly.model.LexiconAttributes = {
    import LexiconAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.polly.model.LexiconAttributes
      .builder()
      .optionallyWith(
        alphabet.map(value => Alphabet.unwrap(value): java.lang.String)
      )(_.alphabet)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        lastModified.map(value => LastModified.unwrap(value): Instant)
      )(_.lastModified)
      .optionallyWith(
        lexiconArn.map(value => LexiconArn.unwrap(value): java.lang.String)
      )(_.lexiconArn)
      .optionallyWith(
        lexemesCount.map(value => LexemesCount.unwrap(value): Integer)
      )(_.lexemesCount)
      .optionallyWith(size.map(value => Size.unwrap(value): Integer))(_.size)
      .build()
  }
  def asReadOnly: zio.aws.polly.model.LexiconAttributes.ReadOnly =
    zio.aws.polly.model.LexiconAttributes.wrap(buildAwsValue())
}
object LexiconAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.polly.model.LexiconAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.polly.model.LexiconAttributes =
      zio.aws.polly.model.LexiconAttributes(
        alphabet.map(value => value),
        languageCode.map(value => value),
        lastModified.map(value => value),
        lexiconArn.map(value => value),
        lexemesCount.map(value => value),
        size.map(value => value)
      )
    def alphabet: Optional[Alphabet]
    def languageCode: Optional[zio.aws.polly.model.LanguageCode]
    def lastModified: Optional[LastModified]
    def lexiconArn: Optional[LexiconArn]
    def lexemesCount: Optional[LexemesCount]
    def size: Optional[Size]
    def getAlphabet: ZIO[Any, AwsError, Alphabet] =
      AwsError.unwrapOptionField("alphabet", alphabet)
    def getLanguageCode: ZIO[Any, AwsError, zio.aws.polly.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getLastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getLexiconArn: ZIO[Any, AwsError, LexiconArn] =
      AwsError.unwrapOptionField("lexiconArn", lexiconArn)
    def getLexemesCount: ZIO[Any, AwsError, LexemesCount] =
      AwsError.unwrapOptionField("lexemesCount", lexemesCount)
    def getSize: ZIO[Any, AwsError, Size] =
      AwsError.unwrapOptionField("size", size)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.polly.model.LexiconAttributes
  ) extends zio.aws.polly.model.LexiconAttributes.ReadOnly {
    override val alphabet: Optional[Alphabet] = zio.aws.core.internal
      .optionalFromNullable(impl.alphabet())
      .map(value => zio.aws.polly.model.primitives.Alphabet(value))
    override val languageCode: Optional[zio.aws.polly.model.LanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value => zio.aws.polly.model.LanguageCode.wrap(value))
    override val lastModified: Optional[LastModified] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModified())
      .map(value => zio.aws.polly.model.primitives.LastModified(value))
    override val lexiconArn: Optional[LexiconArn] = zio.aws.core.internal
      .optionalFromNullable(impl.lexiconArn())
      .map(value => zio.aws.polly.model.primitives.LexiconArn(value))
    override val lexemesCount: Optional[LexemesCount] = zio.aws.core.internal
      .optionalFromNullable(impl.lexemesCount())
      .map(value => zio.aws.polly.model.primitives.LexemesCount(value))
    override val size: Optional[Size] = zio.aws.core.internal
      .optionalFromNullable(impl.size())
      .map(value => zio.aws.polly.model.primitives.Size(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.polly.model.LexiconAttributes
  ): zio.aws.polly.model.LexiconAttributes.ReadOnly = new Wrapper(impl)
}
