package zio.aws.polly.model
import zio.aws.polly.model.primitives.LexiconName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LexiconDescription(
    name: Optional[LexiconName] = Optional.Absent,
    attributes: Optional[zio.aws.polly.model.LexiconAttributes] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.polly.model.LexiconDescription = {
    import LexiconDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.polly.model.LexiconDescription
      .builder()
      .optionallyWith(
        name.map(value => LexiconName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(attributes.map(value => value.buildAwsValue()))(
        _.attributes
      )
      .build()
  }
  def asReadOnly: zio.aws.polly.model.LexiconDescription.ReadOnly =
    zio.aws.polly.model.LexiconDescription.wrap(buildAwsValue())
}
object LexiconDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.polly.model.LexiconDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.polly.model.LexiconDescription =
      zio.aws.polly.model.LexiconDescription(
        name.map(value => value),
        attributes.map(value => value.asEditable)
      )
    def name: Optional[LexiconName]
    def attributes: Optional[zio.aws.polly.model.LexiconAttributes.ReadOnly]
    def getName: ZIO[Any, AwsError, LexiconName] =
      AwsError.unwrapOptionField("name", name)
    def getAttributes
        : ZIO[Any, AwsError, zio.aws.polly.model.LexiconAttributes.ReadOnly] =
      AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.polly.model.LexiconDescription
  ) extends zio.aws.polly.model.LexiconDescription.ReadOnly {
    override val name: Optional[LexiconName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.polly.model.primitives.LexiconName(value))
    override val attributes
        : Optional[zio.aws.polly.model.LexiconAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value => zio.aws.polly.model.LexiconAttributes.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.polly.model.LexiconDescription
  ): zio.aws.polly.model.LexiconDescription.ReadOnly = new Wrapper(impl)
}
