package zio.aws.polly.model
import zio.aws.polly.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListLexiconsResponse(
    lexicons: Optional[Iterable[zio.aws.polly.model.LexiconDescription]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.polly.model.ListLexiconsResponse = {
    import ListLexiconsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.polly.model.ListLexiconsResponse
      .builder()
      .optionallyWith(
        lexicons.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lexicons)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.polly.model.ListLexiconsResponse.ReadOnly =
    zio.aws.polly.model.ListLexiconsResponse.wrap(buildAwsValue())
}
object ListLexiconsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.polly.model.ListLexiconsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.polly.model.ListLexiconsResponse =
      zio.aws.polly.model.ListLexiconsResponse(
        lexicons.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def lexicons
        : Optional[List[zio.aws.polly.model.LexiconDescription.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getLexicons: ZIO[Any, AwsError, List[
      zio.aws.polly.model.LexiconDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("lexicons", lexicons)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.polly.model.ListLexiconsResponse
  ) extends zio.aws.polly.model.ListLexiconsResponse.ReadOnly {
    override val lexicons
        : Optional[List[zio.aws.polly.model.LexiconDescription.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lexicons())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.polly.model.LexiconDescription.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.polly.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.polly.model.ListLexiconsResponse
  ): zio.aws.polly.model.ListLexiconsResponse.ReadOnly = new Wrapper(impl)
}
