package zio.aws.polly.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.polly.model.primitives.{NextToken, MaxResults}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSpeechSynthesisTasksRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    status: Optional[zio.aws.polly.model.TaskStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest = {
    import ListSpeechSynthesisTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.polly.model.ListSpeechSynthesisTasksRequest.ReadOnly =
    zio.aws.polly.model.ListSpeechSynthesisTasksRequest.wrap(buildAwsValue())
}
object ListSpeechSynthesisTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.polly.model.ListSpeechSynthesisTasksRequest =
      zio.aws.polly.model.ListSpeechSynthesisTasksRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        status.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def status: Optional[zio.aws.polly.model.TaskStatus]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStatus: ZIO[Any, AwsError, zio.aws.polly.model.TaskStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest
  ) extends zio.aws.polly.model.ListSpeechSynthesisTasksRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.polly.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.polly.model.primitives.NextToken(value))
    override val status: Optional[zio.aws.polly.model.TaskStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.polly.model.TaskStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest
  ): zio.aws.polly.model.ListSpeechSynthesisTasksRequest.ReadOnly = new Wrapper(
    impl
  )
}
