package zio.aws.polly.model
import zio.aws.polly.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSpeechSynthesisTasksResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    synthesisTasks: Optional[Iterable[zio.aws.polly.model.SynthesisTask]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksResponse = {
    import ListSpeechSynthesisTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        synthesisTasks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.synthesisTasks)
      .build()
  }
  def asReadOnly
      : zio.aws.polly.model.ListSpeechSynthesisTasksResponse.ReadOnly =
    zio.aws.polly.model.ListSpeechSynthesisTasksResponse.wrap(buildAwsValue())
}
object ListSpeechSynthesisTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.polly.model.ListSpeechSynthesisTasksResponse =
      zio.aws.polly.model.ListSpeechSynthesisTasksResponse(
        nextToken.map(value => value),
        synthesisTasks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def synthesisTasks
        : Optional[List[zio.aws.polly.model.SynthesisTask.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSynthesisTasks
        : ZIO[Any, AwsError, List[zio.aws.polly.model.SynthesisTask.ReadOnly]] =
      AwsError.unwrapOptionField("synthesisTasks", synthesisTasks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksResponse
  ) extends zio.aws.polly.model.ListSpeechSynthesisTasksResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.polly.model.primitives.NextToken(value))
    override val synthesisTasks
        : Optional[List[zio.aws.polly.model.SynthesisTask.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.synthesisTasks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.polly.model.SynthesisTask.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksResponse
  ): zio.aws.polly.model.ListSpeechSynthesisTasksResponse.ReadOnly =
    new Wrapper(impl)
}
