package zio.aws.polly.model
import zio.aws.polly.model.primitives.{
  SampleRate,
  OutputS3KeyPrefix,
  Text,
  SnsTopicArn,
  LexiconName,
  OutputS3BucketName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartSpeechSynthesisTaskRequest(
    engine: Optional[zio.aws.polly.model.Engine] = Optional.Absent,
    languageCode: Optional[zio.aws.polly.model.LanguageCode] = Optional.Absent,
    lexiconNames: Optional[Iterable[LexiconName]] = Optional.Absent,
    outputFormat: zio.aws.polly.model.OutputFormat,
    outputS3BucketName: OutputS3BucketName,
    outputS3KeyPrefix: Optional[OutputS3KeyPrefix] = Optional.Absent,
    sampleRate: Optional[SampleRate] = Optional.Absent,
    snsTopicArn: Optional[SnsTopicArn] = Optional.Absent,
    speechMarkTypes: Optional[Iterable[zio.aws.polly.model.SpeechMarkType]] =
      Optional.Absent,
    text: Text,
    textType: Optional[zio.aws.polly.model.TextType] = Optional.Absent,
    voiceId: zio.aws.polly.model.VoiceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.polly.model.StartSpeechSynthesisTaskRequest = {
    import StartSpeechSynthesisTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.polly.model.StartSpeechSynthesisTaskRequest
      .builder()
      .optionallyWith(engine.map(value => value.unwrap))(_.engine)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        lexiconNames.map(value =>
          value.map { item =>
            LexiconName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.lexiconNames)
      .outputFormat(outputFormat.unwrap)
      .outputS3BucketName(
        OutputS3BucketName.unwrap(outputS3BucketName): java.lang.String
      )
      .optionallyWith(
        outputS3KeyPrefix.map(value =>
          OutputS3KeyPrefix.unwrap(value): java.lang.String
        )
      )(_.outputS3KeyPrefix)
      .optionallyWith(
        sampleRate.map(value => SampleRate.unwrap(value): java.lang.String)
      )(_.sampleRate)
      .optionallyWith(
        snsTopicArn.map(value => SnsTopicArn.unwrap(value): java.lang.String)
      )(_.snsTopicArn)
      .optionallyWith(
        speechMarkTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.speechMarkTypesWithStrings)
      .text(Text.unwrap(text): java.lang.String)
      .optionallyWith(textType.map(value => value.unwrap))(_.textType)
      .voiceId(voiceId.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.polly.model.StartSpeechSynthesisTaskRequest.ReadOnly =
    zio.aws.polly.model.StartSpeechSynthesisTaskRequest.wrap(buildAwsValue())
}
object StartSpeechSynthesisTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.polly.model.StartSpeechSynthesisTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.polly.model.StartSpeechSynthesisTaskRequest =
      zio.aws.polly.model.StartSpeechSynthesisTaskRequest(
        engine.map(value => value),
        languageCode.map(value => value),
        lexiconNames.map(value => value),
        outputFormat,
        outputS3BucketName,
        outputS3KeyPrefix.map(value => value),
        sampleRate.map(value => value),
        snsTopicArn.map(value => value),
        speechMarkTypes.map(value => value),
        text,
        textType.map(value => value),
        voiceId
      )
    def engine: Optional[zio.aws.polly.model.Engine]
    def languageCode: Optional[zio.aws.polly.model.LanguageCode]
    def lexiconNames: Optional[List[LexiconName]]
    def outputFormat: zio.aws.polly.model.OutputFormat
    def outputS3BucketName: OutputS3BucketName
    def outputS3KeyPrefix: Optional[OutputS3KeyPrefix]
    def sampleRate: Optional[SampleRate]
    def snsTopicArn: Optional[SnsTopicArn]
    def speechMarkTypes: Optional[List[zio.aws.polly.model.SpeechMarkType]]
    def text: Text
    def textType: Optional[zio.aws.polly.model.TextType]
    def voiceId: zio.aws.polly.model.VoiceId
    def getEngine: ZIO[Any, AwsError, zio.aws.polly.model.Engine] =
      AwsError.unwrapOptionField("engine", engine)
    def getLanguageCode: ZIO[Any, AwsError, zio.aws.polly.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getLexiconNames: ZIO[Any, AwsError, List[LexiconName]] =
      AwsError.unwrapOptionField("lexiconNames", lexiconNames)
    def getOutputFormat: ZIO[Any, Nothing, zio.aws.polly.model.OutputFormat] =
      ZIO.succeed(outputFormat)
    def getOutputS3BucketName: ZIO[Any, Nothing, OutputS3BucketName] =
      ZIO.succeed(outputS3BucketName)
    def getOutputS3KeyPrefix: ZIO[Any, AwsError, OutputS3KeyPrefix] =
      AwsError.unwrapOptionField("outputS3KeyPrefix", outputS3KeyPrefix)
    def getSampleRate: ZIO[Any, AwsError, SampleRate] =
      AwsError.unwrapOptionField("sampleRate", sampleRate)
    def getSnsTopicArn: ZIO[Any, AwsError, SnsTopicArn] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getSpeechMarkTypes
        : ZIO[Any, AwsError, List[zio.aws.polly.model.SpeechMarkType]] =
      AwsError.unwrapOptionField("speechMarkTypes", speechMarkTypes)
    def getText: ZIO[Any, Nothing, Text] = ZIO.succeed(text)
    def getTextType: ZIO[Any, AwsError, zio.aws.polly.model.TextType] =
      AwsError.unwrapOptionField("textType", textType)
    def getVoiceId: ZIO[Any, Nothing, zio.aws.polly.model.VoiceId] =
      ZIO.succeed(voiceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.polly.model.StartSpeechSynthesisTaskRequest
  ) extends zio.aws.polly.model.StartSpeechSynthesisTaskRequest.ReadOnly {
    override val engine: Optional[zio.aws.polly.model.Engine] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engine())
        .map(value => zio.aws.polly.model.Engine.wrap(value))
    override val languageCode: Optional[zio.aws.polly.model.LanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value => zio.aws.polly.model.LanguageCode.wrap(value))
    override val lexiconNames: Optional[List[LexiconName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lexiconNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.polly.model.primitives.LexiconName(item)
          }.toList
        )
    override val outputFormat: zio.aws.polly.model.OutputFormat =
      zio.aws.polly.model.OutputFormat.wrap(impl.outputFormat())
    override val outputS3BucketName: OutputS3BucketName =
      zio.aws.polly.model.primitives
        .OutputS3BucketName(impl.outputS3BucketName())
    override val outputS3KeyPrefix: Optional[OutputS3KeyPrefix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputS3KeyPrefix())
        .map(value => zio.aws.polly.model.primitives.OutputS3KeyPrefix(value))
    override val sampleRate: Optional[SampleRate] = zio.aws.core.internal
      .optionalFromNullable(impl.sampleRate())
      .map(value => zio.aws.polly.model.primitives.SampleRate(value))
    override val snsTopicArn: Optional[SnsTopicArn] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopicArn())
      .map(value => zio.aws.polly.model.primitives.SnsTopicArn(value))
    override val speechMarkTypes
        : Optional[List[zio.aws.polly.model.SpeechMarkType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.speechMarkTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.polly.model.SpeechMarkType.wrap(item)
          }.toList
        )
    override val text: Text = zio.aws.polly.model.primitives.Text(impl.text())
    override val textType: Optional[zio.aws.polly.model.TextType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.textType())
        .map(value => zio.aws.polly.model.TextType.wrap(value))
    override val voiceId: zio.aws.polly.model.VoiceId =
      zio.aws.polly.model.VoiceId.wrap(impl.voiceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.polly.model.StartSpeechSynthesisTaskRequest
  ): zio.aws.polly.model.StartSpeechSynthesisTaskRequest.ReadOnly = new Wrapper(
    impl
  )
}
