package zio.aws.polly.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.polly.model.primitives.{
  SampleRate,
  OutputUri,
  SnsTopicArn,
  DateTime,
  LexiconName,
  TaskStatusReason,
  RequestCharacters,
  TaskId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SynthesisTask(
    engine: Optional[zio.aws.polly.model.Engine] = Optional.Absent,
    taskId: Optional[TaskId] = Optional.Absent,
    taskStatus: Optional[zio.aws.polly.model.TaskStatus] = Optional.Absent,
    taskStatusReason: Optional[TaskStatusReason] = Optional.Absent,
    outputUri: Optional[OutputUri] = Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    requestCharacters: Optional[RequestCharacters] = Optional.Absent,
    snsTopicArn: Optional[SnsTopicArn] = Optional.Absent,
    lexiconNames: Optional[Iterable[LexiconName]] = Optional.Absent,
    outputFormat: Optional[zio.aws.polly.model.OutputFormat] = Optional.Absent,
    sampleRate: Optional[SampleRate] = Optional.Absent,
    speechMarkTypes: Optional[Iterable[zio.aws.polly.model.SpeechMarkType]] =
      Optional.Absent,
    textType: Optional[zio.aws.polly.model.TextType] = Optional.Absent,
    voiceId: Optional[zio.aws.polly.model.VoiceId] = Optional.Absent,
    languageCode: Optional[zio.aws.polly.model.LanguageCode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.polly.model.SynthesisTask = {
    import SynthesisTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.polly.model.SynthesisTask
      .builder()
      .optionallyWith(engine.map(value => value.unwrap))(_.engine)
      .optionallyWith(
        taskId.map(value => TaskId.unwrap(value): java.lang.String)
      )(_.taskId)
      .optionallyWith(taskStatus.map(value => value.unwrap))(_.taskStatus)
      .optionallyWith(
        taskStatusReason.map(value =>
          TaskStatusReason.unwrap(value): java.lang.String
        )
      )(_.taskStatusReason)
      .optionallyWith(
        outputUri.map(value => OutputUri.unwrap(value): java.lang.String)
      )(_.outputUri)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        requestCharacters.map(value => RequestCharacters.unwrap(value): Integer)
      )(_.requestCharacters)
      .optionallyWith(
        snsTopicArn.map(value => SnsTopicArn.unwrap(value): java.lang.String)
      )(_.snsTopicArn)
      .optionallyWith(
        lexiconNames.map(value =>
          value.map { item =>
            LexiconName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.lexiconNames)
      .optionallyWith(outputFormat.map(value => value.unwrap))(_.outputFormat)
      .optionallyWith(
        sampleRate.map(value => SampleRate.unwrap(value): java.lang.String)
      )(_.sampleRate)
      .optionallyWith(
        speechMarkTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.speechMarkTypesWithStrings)
      .optionallyWith(textType.map(value => value.unwrap))(_.textType)
      .optionallyWith(voiceId.map(value => value.unwrap))(_.voiceId)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .build()
  }
  def asReadOnly: zio.aws.polly.model.SynthesisTask.ReadOnly =
    zio.aws.polly.model.SynthesisTask.wrap(buildAwsValue())
}
object SynthesisTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.polly.model.SynthesisTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.polly.model.SynthesisTask =
      zio.aws.polly.model.SynthesisTask(
        engine.map(value => value),
        taskId.map(value => value),
        taskStatus.map(value => value),
        taskStatusReason.map(value => value),
        outputUri.map(value => value),
        creationTime.map(value => value),
        requestCharacters.map(value => value),
        snsTopicArn.map(value => value),
        lexiconNames.map(value => value),
        outputFormat.map(value => value),
        sampleRate.map(value => value),
        speechMarkTypes.map(value => value),
        textType.map(value => value),
        voiceId.map(value => value),
        languageCode.map(value => value)
      )
    def engine: Optional[zio.aws.polly.model.Engine]
    def taskId: Optional[TaskId]
    def taskStatus: Optional[zio.aws.polly.model.TaskStatus]
    def taskStatusReason: Optional[TaskStatusReason]
    def outputUri: Optional[OutputUri]
    def creationTime: Optional[DateTime]
    def requestCharacters: Optional[RequestCharacters]
    def snsTopicArn: Optional[SnsTopicArn]
    def lexiconNames: Optional[List[LexiconName]]
    def outputFormat: Optional[zio.aws.polly.model.OutputFormat]
    def sampleRate: Optional[SampleRate]
    def speechMarkTypes: Optional[List[zio.aws.polly.model.SpeechMarkType]]
    def textType: Optional[zio.aws.polly.model.TextType]
    def voiceId: Optional[zio.aws.polly.model.VoiceId]
    def languageCode: Optional[zio.aws.polly.model.LanguageCode]
    def getEngine: ZIO[Any, AwsError, zio.aws.polly.model.Engine] =
      AwsError.unwrapOptionField("engine", engine)
    def getTaskId: ZIO[Any, AwsError, TaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
    def getTaskStatus: ZIO[Any, AwsError, zio.aws.polly.model.TaskStatus] =
      AwsError.unwrapOptionField("taskStatus", taskStatus)
    def getTaskStatusReason: ZIO[Any, AwsError, TaskStatusReason] =
      AwsError.unwrapOptionField("taskStatusReason", taskStatusReason)
    def getOutputUri: ZIO[Any, AwsError, OutputUri] =
      AwsError.unwrapOptionField("outputUri", outputUri)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getRequestCharacters: ZIO[Any, AwsError, RequestCharacters] =
      AwsError.unwrapOptionField("requestCharacters", requestCharacters)
    def getSnsTopicArn: ZIO[Any, AwsError, SnsTopicArn] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getLexiconNames: ZIO[Any, AwsError, List[LexiconName]] =
      AwsError.unwrapOptionField("lexiconNames", lexiconNames)
    def getOutputFormat: ZIO[Any, AwsError, zio.aws.polly.model.OutputFormat] =
      AwsError.unwrapOptionField("outputFormat", outputFormat)
    def getSampleRate: ZIO[Any, AwsError, SampleRate] =
      AwsError.unwrapOptionField("sampleRate", sampleRate)
    def getSpeechMarkTypes
        : ZIO[Any, AwsError, List[zio.aws.polly.model.SpeechMarkType]] =
      AwsError.unwrapOptionField("speechMarkTypes", speechMarkTypes)
    def getTextType: ZIO[Any, AwsError, zio.aws.polly.model.TextType] =
      AwsError.unwrapOptionField("textType", textType)
    def getVoiceId: ZIO[Any, AwsError, zio.aws.polly.model.VoiceId] =
      AwsError.unwrapOptionField("voiceId", voiceId)
    def getLanguageCode: ZIO[Any, AwsError, zio.aws.polly.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.polly.model.SynthesisTask
  ) extends zio.aws.polly.model.SynthesisTask.ReadOnly {
    override val engine: Optional[zio.aws.polly.model.Engine] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engine())
        .map(value => zio.aws.polly.model.Engine.wrap(value))
    override val taskId: Optional[TaskId] = zio.aws.core.internal
      .optionalFromNullable(impl.taskId())
      .map(value => zio.aws.polly.model.primitives.TaskId(value))
    override val taskStatus: Optional[zio.aws.polly.model.TaskStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskStatus())
        .map(value => zio.aws.polly.model.TaskStatus.wrap(value))
    override val taskStatusReason: Optional[TaskStatusReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskStatusReason())
        .map(value => zio.aws.polly.model.primitives.TaskStatusReason(value))
    override val outputUri: Optional[OutputUri] = zio.aws.core.internal
      .optionalFromNullable(impl.outputUri())
      .map(value => zio.aws.polly.model.primitives.OutputUri(value))
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.polly.model.primitives.DateTime(value))
    override val requestCharacters: Optional[RequestCharacters] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestCharacters())
        .map(value => zio.aws.polly.model.primitives.RequestCharacters(value))
    override val snsTopicArn: Optional[SnsTopicArn] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopicArn())
      .map(value => zio.aws.polly.model.primitives.SnsTopicArn(value))
    override val lexiconNames: Optional[List[LexiconName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lexiconNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.polly.model.primitives.LexiconName(item)
          }.toList
        )
    override val outputFormat: Optional[zio.aws.polly.model.OutputFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputFormat())
        .map(value => zio.aws.polly.model.OutputFormat.wrap(value))
    override val sampleRate: Optional[SampleRate] = zio.aws.core.internal
      .optionalFromNullable(impl.sampleRate())
      .map(value => zio.aws.polly.model.primitives.SampleRate(value))
    override val speechMarkTypes
        : Optional[List[zio.aws.polly.model.SpeechMarkType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.speechMarkTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.polly.model.SpeechMarkType.wrap(item)
          }.toList
        )
    override val textType: Optional[zio.aws.polly.model.TextType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.textType())
        .map(value => zio.aws.polly.model.TextType.wrap(value))
    override val voiceId: Optional[zio.aws.polly.model.VoiceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceId())
        .map(value => zio.aws.polly.model.VoiceId.wrap(value))
    override val languageCode: Optional[zio.aws.polly.model.LanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value => zio.aws.polly.model.LanguageCode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.polly.model.SynthesisTask
  ): zio.aws.polly.model.SynthesisTask.ReadOnly = new Wrapper(impl)
}
