package zio.aws.polly.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.polly.model.primitives.{RequestCharacters, ContentType}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SynthesizeSpeechResponse(
    contentType: Optional[ContentType] = Optional.Absent,
    requestCharacters: Optional[RequestCharacters] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.polly.model.SynthesizeSpeechResponse = {
    import SynthesizeSpeechResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.polly.model.SynthesizeSpeechResponse
      .builder()
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(
        requestCharacters.map(value => RequestCharacters.unwrap(value): Integer)
      )(_.requestCharacters)
      .build()
  }
  def asReadOnly: zio.aws.polly.model.SynthesizeSpeechResponse.ReadOnly =
    zio.aws.polly.model.SynthesizeSpeechResponse.wrap(buildAwsValue())
}
object SynthesizeSpeechResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.polly.model.SynthesizeSpeechResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.polly.model.SynthesizeSpeechResponse =
      zio.aws.polly.model.SynthesizeSpeechResponse(
        contentType.map(value => value),
        requestCharacters.map(value => value)
      )
    def contentType: Optional[ContentType]
    def requestCharacters: Optional[RequestCharacters]
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getRequestCharacters: ZIO[Any, AwsError, RequestCharacters] =
      AwsError.unwrapOptionField("requestCharacters", requestCharacters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.polly.model.SynthesizeSpeechResponse
  ) extends zio.aws.polly.model.SynthesizeSpeechResponse.ReadOnly {
    override val contentType: Optional[ContentType] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value => zio.aws.polly.model.primitives.ContentType(value))
    override val requestCharacters: Optional[RequestCharacters] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestCharacters())
        .map(value => zio.aws.polly.model.primitives.RequestCharacters(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.polly.model.SynthesizeSpeechResponse
  ): zio.aws.polly.model.SynthesizeSpeechResponse.ReadOnly = new Wrapper(impl)
}
