package zio.aws.polly.model
import scala.jdk.CollectionConverters._
sealed trait TextType {
  def unwrap: software.amazon.awssdk.services.polly.model.TextType
}
object TextType {
  def wrap(
      value: software.amazon.awssdk.services.polly.model.TextType
  ): zio.aws.polly.model.TextType = value match {
    case software.amazon.awssdk.services.polly.model.TextType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.polly.model.TextType.SSML =>
      val r = ssml
      r
    case software.amazon.awssdk.services.polly.model.TextType.TEXT =>
      val r = text
      r
  }
  case object unknownToSdkVersion extends zio.aws.polly.model.TextType {
    override def unwrap: software.amazon.awssdk.services.polly.model.TextType =
      software.amazon.awssdk.services.polly.model.TextType.UNKNOWN_TO_SDK_VERSION
  }
  case object ssml extends zio.aws.polly.model.TextType {
    override def unwrap: software.amazon.awssdk.services.polly.model.TextType =
      software.amazon.awssdk.services.polly.model.TextType.SSML
  }
  case object text extends zio.aws.polly.model.TextType {
    override def unwrap: software.amazon.awssdk.services.polly.model.TextType =
      software.amazon.awssdk.services.polly.model.TextType.TEXT
  }
}
