package zio.aws.pricing
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.pricing.{
  PricingAsyncClientBuilder,
  PricingAsyncClient
}
import zio.aws.pricing.model.Service.ReadOnly
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.aws.pricing.model.{
  GetProductsRequest,
  GetAttributeValuesRequest,
  DescribeServicesRequest
}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.aws.pricing.model.primitives.PriceListItemJSON
import software.amazon.awssdk.services.pricing.model.{
  DescribeServicesResponse,
  GetAttributeValuesResponse,
  Service,
  GetProductsResponse,
  AttributeValue
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Pricing extends AspectSupport[Pricing] {
  val api: PricingAsyncClient
  def describeServices(
      request: DescribeServicesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.pricing.model.DescribeServicesResponse.ReadOnly,
    ReadOnly
  ]]
  def describeServicesPaginated(
      request: DescribeServicesRequest
  ): IO[AwsError, zio.aws.pricing.model.DescribeServicesResponse.ReadOnly]
  def getAttributeValues(
      request: GetAttributeValuesRequest
  ): ZStream[Any, AwsError, zio.aws.pricing.model.AttributeValue.ReadOnly]
  def getAttributeValuesPaginated(
      request: GetAttributeValuesRequest
  ): IO[AwsError, zio.aws.pricing.model.GetAttributeValuesResponse.ReadOnly]
  def getProducts(
      request: GetProductsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.pricing.model.GetProductsResponse.ReadOnly,
    PriceListItemJSON
  ]]
  def getProductsPaginated(
      request: GetProductsRequest
  ): IO[AwsError, zio.aws.pricing.model.GetProductsResponse.ReadOnly]
}
object Pricing {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Pricing] = customized(
    identity
  )
  def customized(
      customization: PricingAsyncClientBuilder => PricingAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Pricing] = managed(
    customization
  ).toLayer
  def managed(
      customization: PricingAsyncClientBuilder => PricingAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Pricing] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = PricingAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[PricingAsyncClient, PricingAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[PricingAsyncClient, PricingAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new PricingImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class PricingImpl[R](
      override val api: PricingAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Pricing
      with AwsServiceBase[R] {
    override val serviceName: String = "Pricing"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): PricingImpl[R1] = new PricingImpl(api, newAspect, r)
    def describeServices(
        request: DescribeServicesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.pricing.model.DescribeServicesResponse.ReadOnly,
      ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.pricing.model.DescribeServicesRequest,
      DescribeServicesResponse,
      Service
    ](
      "describeServices",
      api.describeServices,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.services().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.pricing.model.DescribeServicesResponse.wrap)
          .mapOutput(_.map(item => zio.aws.pricing.model.Service.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeServicesPaginated(
        request: DescribeServicesRequest
    ): IO[AwsError, zio.aws.pricing.model.DescribeServicesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.pricing.model.DescribeServicesRequest,
        DescribeServicesResponse
      ]("describeServices", api.describeServices)(request.buildAwsValue())
        .map(zio.aws.pricing.model.DescribeServicesResponse.wrap)
        .provideEnvironment(r)
    def getAttributeValues(
        request: GetAttributeValuesRequest
    ): ZStream[Any, AwsError, zio.aws.pricing.model.AttributeValue.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest,
        GetAttributeValuesResponse,
        AttributeValue
      ](
        "getAttributeValues",
        api.getAttributeValues,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.attributeValues().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.pricing.model.AttributeValue.wrap(item))
        .provideEnvironment(r)
    def getAttributeValuesPaginated(
        request: GetAttributeValuesRequest
    ): IO[AwsError, zio.aws.pricing.model.GetAttributeValuesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest,
        GetAttributeValuesResponse
      ]("getAttributeValues", api.getAttributeValues)(request.buildAwsValue())
        .map(zio.aws.pricing.model.GetAttributeValuesResponse.wrap)
        .provideEnvironment(r)
    def getProducts(
        request: GetProductsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.pricing.model.GetProductsResponse.ReadOnly,
      PriceListItemJSON
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.pricing.model.GetProductsRequest,
      GetProductsResponse,
      java.lang.String
    ](
      "getProducts",
      api.getProducts,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.priceList().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.pricing.model.GetProductsResponse.wrap)
          .mapOutput(
            _.map(item =>
              zio.aws.pricing.model.primitives.PriceListItemJSON(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getProductsPaginated(
        request: GetProductsRequest
    ): IO[AwsError, zio.aws.pricing.model.GetProductsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.pricing.model.GetProductsRequest,
        GetProductsResponse
      ]("getProducts", api.getProducts)(request.buildAwsValue())
        .map(zio.aws.pricing.model.GetProductsResponse.wrap)
        .provideEnvironment(r)
  }
  def describeServices(
      request: DescribeServicesRequest
  ): ZIO[zio.aws.pricing.Pricing, AwsError, StreamingOutputResult[
    Any,
    zio.aws.pricing.model.DescribeServicesResponse.ReadOnly,
    ReadOnly
  ]] = ZIO.serviceWithZIO(_.describeServices(request))
  def describeServicesPaginated(request: DescribeServicesRequest): ZIO[
    zio.aws.pricing.Pricing,
    AwsError,
    zio.aws.pricing.model.DescribeServicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeServicesPaginated(request))
  def getAttributeValues(request: GetAttributeValuesRequest): ZStream[
    zio.aws.pricing.Pricing,
    AwsError,
    zio.aws.pricing.model.AttributeValue.ReadOnly
  ] = ZStream.serviceWithStream(_.getAttributeValues(request))
  def getAttributeValuesPaginated(request: GetAttributeValuesRequest): ZIO[
    zio.aws.pricing.Pricing,
    AwsError,
    zio.aws.pricing.model.GetAttributeValuesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAttributeValuesPaginated(request))
  def getProducts(
      request: GetProductsRequest
  ): ZIO[zio.aws.pricing.Pricing, AwsError, StreamingOutputResult[
    Any,
    zio.aws.pricing.model.GetProductsResponse.ReadOnly,
    PriceListItemJSON
  ]] = ZIO.serviceWithZIO(_.getProducts(request))
  def getProductsPaginated(request: GetProductsRequest): ZIO[
    zio.aws.pricing.Pricing,
    AwsError,
    zio.aws.pricing.model.GetProductsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getProductsPaginated(request))
}
