package zio.aws.pricing
import software.amazon.awssdk.services.pricing.PricingAsyncClient
import zio.aws.pricing.model.Service.ReadOnly
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.aws.pricing.model.{
  GetProductsRequest,
  GetAttributeValuesRequest,
  DescribeServicesRequest
}
import zio.{IO, ZIO, ZEnvironment, URLayer}
import zio.aws.pricing.model.primitives.PriceListItemJSON
import zio.stream.ZStream
import zio.test.mock.{Proxy, Mock}
object PricingMock extends Mock[Pricing] {
  object DescribeServices
      extends Effect[DescribeServicesRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.pricing.model.DescribeServicesResponse.ReadOnly,
        ReadOnly
      ]]
  object DescribeServicesPaginated
      extends Effect[
        DescribeServicesRequest,
        AwsError,
        zio.aws.pricing.model.DescribeServicesResponse.ReadOnly
      ]
  object GetAttributeValues
      extends Stream[
        GetAttributeValuesRequest,
        AwsError,
        zio.aws.pricing.model.AttributeValue.ReadOnly
      ]
  object GetAttributeValuesPaginated
      extends Effect[
        GetAttributeValuesRequest,
        AwsError,
        zio.aws.pricing.model.GetAttributeValuesResponse.ReadOnly
      ]
  object GetProducts
      extends Effect[GetProductsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.pricing.model.GetProductsResponse.ReadOnly,
        PriceListItemJSON
      ]]
  object GetProductsPaginated
      extends Effect[
        GetProductsRequest,
        AwsError,
        zio.aws.pricing.model.GetProductsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Pricing] = ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Pricing {
          val api: PricingAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Pricing = this
          def describeServices(
              request: DescribeServicesRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.pricing.model.DescribeServicesResponse.ReadOnly,
            ReadOnly
          ]] = proxy(DescribeServices, request)
          def describeServicesPaginated(request: DescribeServicesRequest): IO[
            AwsError,
            zio.aws.pricing.model.DescribeServicesResponse.ReadOnly
          ] = proxy(DescribeServicesPaginated, request)
          def getAttributeValues(request: GetAttributeValuesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.pricing.model.AttributeValue.ReadOnly
          ] = rts.unsafeRun(proxy(GetAttributeValues, request))
          def getAttributeValuesPaginated(
              request: GetAttributeValuesRequest
          ): IO[
            AwsError,
            zio.aws.pricing.model.GetAttributeValuesResponse.ReadOnly
          ] = proxy(GetAttributeValuesPaginated, request)
          def getProducts(
              request: GetProductsRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.pricing.model.GetProductsResponse.ReadOnly,
            PriceListItemJSON
          ]] = proxy(GetProducts, request)
          def getProductsPaginated(
              request: GetProductsRequest
          ): IO[AwsError, zio.aws.pricing.model.GetProductsResponse.ReadOnly] =
            proxy(GetProductsPaginated, request)
        }
      }
    }
    .toLayer
}
