package zio.aws.pricing.model
import java.lang.Integer
import zio.aws.pricing.model.primitives.BoxedInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetAttributeValuesRequest(
    serviceCode: String,
    attributeName: String,
    nextToken: Option[String] = None,
    maxResults: Option[BoxedInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest = {
    import GetAttributeValuesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest
      .builder()
      .serviceCode(serviceCode: java.lang.String)
      .attributeName(attributeName: java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => BoxedInteger.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.pricing.model.GetAttributeValuesRequest.ReadOnly =
    zio.aws.pricing.model.GetAttributeValuesRequest.wrap(buildAwsValue())
}
object GetAttributeValuesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pricing.model.GetAttributeValuesRequest =
      zio.aws.pricing.model.GetAttributeValuesRequest(
        serviceCode,
        attributeName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def serviceCode: String
    def attributeName: String
    def nextToken: Option[String]
    def maxResults: Option[BoxedInteger]
    def getServiceCode: ZIO[Any, Nothing, String] = ZIO.succeed(serviceCode)
    def getAttributeName: ZIO[Any, Nothing, String] = ZIO.succeed(attributeName)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest
  ) extends zio.aws.pricing.model.GetAttributeValuesRequest.ReadOnly {
    override val serviceCode: String = impl.serviceCode(): String
    override val attributeName: String = impl.attributeName(): String
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[BoxedInteger] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.pricing.model.primitives.BoxedInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest
  ): zio.aws.pricing.model.GetAttributeValuesRequest.ReadOnly = new Wrapper(
    impl
  )
}
