package zio.aws.pricing.model
import java.lang.Integer
import zio.aws.pricing.model.primitives.BoxedInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetProductsRequest(
    serviceCode: Option[String] = None,
    filters: Option[Iterable[zio.aws.pricing.model.Filter]] = None,
    formatVersion: Option[String] = None,
    nextToken: Option[String] = None,
    maxResults: Option[BoxedInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pricing.model.GetProductsRequest = {
    import GetProductsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pricing.model.GetProductsRequest
      .builder()
      .optionallyWith(serviceCode.map(value => value: java.lang.String))(
        _.serviceCode
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(formatVersion.map(value => value: java.lang.String))(
        _.formatVersion
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => BoxedInteger.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.pricing.model.GetProductsRequest.ReadOnly =
    zio.aws.pricing.model.GetProductsRequest.wrap(buildAwsValue())
}
object GetProductsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pricing.model.GetProductsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pricing.model.GetProductsRequest =
      zio.aws.pricing.model.GetProductsRequest(
        serviceCode.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        formatVersion.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def serviceCode: Option[String]
    def filters: Option[List[zio.aws.pricing.model.Filter.ReadOnly]]
    def formatVersion: Option[String]
    def nextToken: Option[String]
    def maxResults: Option[BoxedInteger]
    def getServiceCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceCode", serviceCode)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.pricing.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getFormatVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("formatVersion", formatVersion)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pricing.model.GetProductsRequest
  ) extends zio.aws.pricing.model.GetProductsRequest.ReadOnly {
    override val serviceCode: Option[String] =
      scala.Option(impl.serviceCode()).map(value => value: String)
    override val filters: Option[List[zio.aws.pricing.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pricing.model.Filter.wrap(item)
          }.toList
        )
    override val formatVersion: Option[String] =
      scala.Option(impl.formatVersion()).map(value => value: String)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[BoxedInteger] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.pricing.model.primitives.BoxedInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pricing.model.GetProductsRequest
  ): zio.aws.pricing.model.GetProductsRequest.ReadOnly = new Wrapper(impl)
}
