package zio.aws.pricing.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.pricing.model.primitives.BoxedInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetProductsRequest(
    serviceCode: Optional[String] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.pricing.model.Filter]] = Optional.Absent,
    formatVersion: Optional[String] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[BoxedInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pricing.model.GetProductsRequest = {
    import GetProductsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pricing.model.GetProductsRequest
      .builder()
      .optionallyWith(serviceCode.map(value => value: java.lang.String))(
        _.serviceCode
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(formatVersion.map(value => value: java.lang.String))(
        _.formatVersion
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.pricing.model.GetProductsRequest.ReadOnly =
    zio.aws.pricing.model.GetProductsRequest.wrap(buildAwsValue())
}
object GetProductsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pricing.model.GetProductsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pricing.model.GetProductsRequest =
      zio.aws.pricing.model.GetProductsRequest(
        serviceCode.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        formatVersion.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def serviceCode: Optional[String]
    def filters: Optional[List[zio.aws.pricing.model.Filter.ReadOnly]]
    def formatVersion: Optional[String]
    def nextToken: Optional[String]
    def maxResults: Optional[BoxedInteger]
    def getServiceCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceCode", serviceCode)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.pricing.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getFormatVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("formatVersion", formatVersion)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pricing.model.GetProductsRequest
  ) extends zio.aws.pricing.model.GetProductsRequest.ReadOnly {
    override val serviceCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceCode())
      .map(value => value: String)
    override val filters
        : Optional[List[zio.aws.pricing.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pricing.model.Filter.wrap(item)
          }.toList
        )
    override val formatVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.formatVersion())
      .map(value => value: String)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: BoxedInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pricing.model.GetProductsRequest
  ): zio.aws.pricing.model.GetProductsRequest.ReadOnly = new Wrapper(impl)
}
