package zio.aws.pricing.model
import zio.aws.pricing.model.primitives.PriceListItemJSON
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetProductsResponse(
    formatVersion: Optional[String] = Optional.Absent,
    priceList: Optional[Iterable[PriceListItemJSON]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pricing.model.GetProductsResponse = {
    import GetProductsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pricing.model.GetProductsResponse
      .builder()
      .optionallyWith(formatVersion.map(value => value: java.lang.String))(
        _.formatVersion
      )
      .optionallyWith(
        priceList.map(value =>
          value.map { item =>
            PriceListItemJSON.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.priceList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.pricing.model.GetProductsResponse.ReadOnly =
    zio.aws.pricing.model.GetProductsResponse.wrap(buildAwsValue())
}
object GetProductsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pricing.model.GetProductsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pricing.model.GetProductsResponse =
      zio.aws.pricing.model.GetProductsResponse(
        formatVersion.map(value => value),
        priceList.map(value => value),
        nextToken.map(value => value)
      )
    def formatVersion: Optional[String]
    def priceList: Optional[List[PriceListItemJSON]]
    def nextToken: Optional[String]
    def getFormatVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("formatVersion", formatVersion)
    def getPriceList: ZIO[Any, AwsError, List[PriceListItemJSON]] =
      AwsError.unwrapOptionField("priceList", priceList)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pricing.model.GetProductsResponse
  ) extends zio.aws.pricing.model.GetProductsResponse.ReadOnly {
    override val formatVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.formatVersion())
      .map(value => value: String)
    override val priceList: Optional[List[PriceListItemJSON]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.priceList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pricing.model.primitives.PriceListItemJSON(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pricing.model.GetProductsResponse
  ): zio.aws.pricing.model.GetProductsResponse.ReadOnly = new Wrapper(impl)
}
