package zio.aws.pricing.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.pricing.model.primitives.BoxedInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeServicesRequest(
    serviceCode: Optional[String] = Optional.Absent,
    formatVersion: Optional[String] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[BoxedInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pricing.model.DescribeServicesRequest = {
    import DescribeServicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pricing.model.DescribeServicesRequest
      .builder()
      .optionallyWith(serviceCode.map(value => value: java.lang.String))(
        _.serviceCode
      )
      .optionallyWith(formatVersion.map(value => value: java.lang.String))(
        _.formatVersion
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.pricing.model.DescribeServicesRequest.ReadOnly =
    zio.aws.pricing.model.DescribeServicesRequest.wrap(buildAwsValue())
}
object DescribeServicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pricing.model.DescribeServicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pricing.model.DescribeServicesRequest =
      zio.aws.pricing.model.DescribeServicesRequest(
        serviceCode.map(value => value),
        formatVersion.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def serviceCode: Optional[String]
    def formatVersion: Optional[String]
    def nextToken: Optional[String]
    def maxResults: Optional[BoxedInteger]
    def getServiceCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceCode", serviceCode)
    def getFormatVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("formatVersion", formatVersion)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pricing.model.DescribeServicesRequest
  ) extends zio.aws.pricing.model.DescribeServicesRequest.ReadOnly {
    override val serviceCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceCode())
      .map(value => value: String)
    override val formatVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.formatVersion())
      .map(value => value: String)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: BoxedInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pricing.model.DescribeServicesRequest
  ): zio.aws.pricing.model.DescribeServicesRequest.ReadOnly = new Wrapper(impl)
}
