package zio.aws.pricing.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeServicesResponse(
    services: Optional[Iterable[zio.aws.pricing.model.Service]] =
      Optional.Absent,
    formatVersion: Optional[String] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pricing.model.DescribeServicesResponse = {
    import DescribeServicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pricing.model.DescribeServicesResponse
      .builder()
      .optionallyWith(
        services.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.services)
      .optionallyWith(formatVersion.map(value => value: java.lang.String))(
        _.formatVersion
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.pricing.model.DescribeServicesResponse.ReadOnly =
    zio.aws.pricing.model.DescribeServicesResponse.wrap(buildAwsValue())
}
object DescribeServicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pricing.model.DescribeServicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pricing.model.DescribeServicesResponse =
      zio.aws.pricing.model.DescribeServicesResponse(
        services.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        formatVersion.map(value => value),
        nextToken.map(value => value)
      )
    def services: Optional[List[zio.aws.pricing.model.Service.ReadOnly]]
    def formatVersion: Optional[String]
    def nextToken: Optional[String]
    def getServices
        : ZIO[Any, AwsError, List[zio.aws.pricing.model.Service.ReadOnly]] =
      AwsError.unwrapOptionField("services", services)
    def getFormatVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("formatVersion", formatVersion)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pricing.model.DescribeServicesResponse
  ) extends zio.aws.pricing.model.DescribeServicesResponse.ReadOnly {
    override val services
        : Optional[List[zio.aws.pricing.model.Service.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.services())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pricing.model.Service.wrap(item)
          }.toList
        )
    override val formatVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.formatVersion())
      .map(value => value: String)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pricing.model.DescribeServicesResponse
  ): zio.aws.pricing.model.DescribeServicesResponse.ReadOnly = new Wrapper(impl)
}
