package zio.aws.pricing.model
import java.lang.Integer
import zio.aws.pricing.model.primitives.BoxedInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeServicesRequest(
    serviceCode: Option[String] = None,
    formatVersion: Option[String] = None,
    nextToken: Option[String] = None,
    maxResults: Option[BoxedInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pricing.model.DescribeServicesRequest = {
    import DescribeServicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pricing.model.DescribeServicesRequest
      .builder()
      .optionallyWith(serviceCode.map(value => value: java.lang.String))(
        _.serviceCode
      )
      .optionallyWith(formatVersion.map(value => value: java.lang.String))(
        _.formatVersion
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.pricing.model.DescribeServicesRequest.ReadOnly =
    zio.aws.pricing.model.DescribeServicesRequest.wrap(buildAwsValue())
}
object DescribeServicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pricing.model.DescribeServicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pricing.model.DescribeServicesRequest =
      zio.aws.pricing.model.DescribeServicesRequest(
        serviceCode.map(value => value),
        formatVersion.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def serviceCode: Option[String]
    def formatVersion: Option[String]
    def nextToken: Option[String]
    def maxResults: Option[BoxedInteger]
    def getServiceCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceCode", serviceCode)
    def getFormatVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("formatVersion", formatVersion)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pricing.model.DescribeServicesRequest
  ) extends zio.aws.pricing.model.DescribeServicesRequest.ReadOnly {
    override val serviceCode: Option[String] =
      scala.Option(impl.serviceCode()).map(value => value: String)
    override val formatVersion: Option[String] =
      scala.Option(impl.formatVersion()).map(value => value: String)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[BoxedInteger] =
      scala.Option(impl.maxResults()).map(value => value: BoxedInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pricing.model.DescribeServicesRequest
  ): zio.aws.pricing.model.DescribeServicesRequest.ReadOnly = new Wrapper(impl)
}
