package zio.aws.pricing.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AttributeValue(value: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pricing.model.AttributeValue = {
    import AttributeValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pricing.model.AttributeValue
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.pricing.model.AttributeValue.ReadOnly =
    zio.aws.pricing.model.AttributeValue.wrap(buildAwsValue())
}
object AttributeValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pricing.model.AttributeValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pricing.model.AttributeValue =
      zio.aws.pricing.model.AttributeValue(value.map(value => value))
    def value: Option[String]
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pricing.model.AttributeValue
  ) extends zio.aws.pricing.model.AttributeValue.ReadOnly {
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pricing.model.AttributeValue
  ): zio.aws.pricing.model.AttributeValue.ReadOnly = new Wrapper(impl)
}
