package zio.aws.pricing.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeServicesResponse(
    services: Option[Iterable[zio.aws.pricing.model.Service]] = None,
    formatVersion: Option[String] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pricing.model.DescribeServicesResponse = {
    import DescribeServicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pricing.model.DescribeServicesResponse
      .builder()
      .optionallyWith(
        services.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.services)
      .optionallyWith(formatVersion.map(value => value: java.lang.String))(
        _.formatVersion
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.pricing.model.DescribeServicesResponse.ReadOnly =
    zio.aws.pricing.model.DescribeServicesResponse.wrap(buildAwsValue())
}
object DescribeServicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pricing.model.DescribeServicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pricing.model.DescribeServicesResponse =
      zio.aws.pricing.model.DescribeServicesResponse(
        services.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        formatVersion.map(value => value),
        nextToken.map(value => value)
      )
    def services: Option[List[zio.aws.pricing.model.Service.ReadOnly]]
    def formatVersion: Option[String]
    def nextToken: Option[String]
    def getServices
        : ZIO[Any, AwsError, List[zio.aws.pricing.model.Service.ReadOnly]] =
      AwsError.unwrapOptionField("services", services)
    def getFormatVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("formatVersion", formatVersion)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pricing.model.DescribeServicesResponse
  ) extends zio.aws.pricing.model.DescribeServicesResponse.ReadOnly {
    override val services
        : Option[List[zio.aws.pricing.model.Service.ReadOnly]] = scala
      .Option(impl.services())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pricing.model.Service.wrap(item)
        }.toList
      )
    override val formatVersion: Option[String] =
      scala.Option(impl.formatVersion()).map(value => value: String)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pricing.model.DescribeServicesResponse
  ): zio.aws.pricing.model.DescribeServicesResponse.ReadOnly = new Wrapper(impl)
}
