package zio.aws.pricing.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Service(
    serviceCode: Option[String] = None,
    attributeNames: Option[Iterable[String]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.pricing.model.Service = {
    import Service.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pricing.model.Service
      .builder()
      .optionallyWith(serviceCode.map(value => value: java.lang.String))(
        _.serviceCode
      )
      .optionallyWith(
        attributeNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.attributeNames)
      .build()
  }
  def asReadOnly: zio.aws.pricing.model.Service.ReadOnly =
    zio.aws.pricing.model.Service.wrap(buildAwsValue())
}
object Service {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pricing.model.Service] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pricing.model.Service =
      zio.aws.pricing.model.Service(
        serviceCode.map(value => value),
        attributeNames.map(value => value)
      )
    def serviceCode: Option[String]
    def attributeNames: Option[List[String]]
    def getServiceCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceCode", serviceCode)
    def getAttributeNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("attributeNames", attributeNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pricing.model.Service
  ) extends zio.aws.pricing.model.Service.ReadOnly {
    override val serviceCode: Option[String] =
      scala.Option(impl.serviceCode()).map(value => value: String)
    override val attributeNames: Option[List[String]] = scala
      .Option(impl.attributeNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pricing.model.Service
  ): zio.aws.pricing.model.Service.ReadOnly = new Wrapper(impl)
}
