package zio.aws.pricing.model
import zio.aws.pricing.model.primitives.PriceListItemJSON
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetProductsResponse(
    formatVersion: Option[String] = None,
    priceList: Option[Iterable[PriceListItemJSON]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pricing.model.GetProductsResponse = {
    import GetProductsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pricing.model.GetProductsResponse
      .builder()
      .optionallyWith(formatVersion.map(value => value: java.lang.String))(
        _.formatVersion
      )
      .optionallyWith(
        priceList.map(value =>
          value.map { item =>
            PriceListItemJSON.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.priceList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.pricing.model.GetProductsResponse.ReadOnly =
    zio.aws.pricing.model.GetProductsResponse.wrap(buildAwsValue())
}
object GetProductsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pricing.model.GetProductsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pricing.model.GetProductsResponse =
      zio.aws.pricing.model.GetProductsResponse(
        formatVersion.map(value => value),
        priceList.map(value => value),
        nextToken.map(value => value)
      )
    def formatVersion: Option[String]
    def priceList: Option[List[PriceListItemJSON]]
    def nextToken: Option[String]
    def getFormatVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("formatVersion", formatVersion)
    def getPriceList: ZIO[Any, AwsError, List[PriceListItemJSON]] =
      AwsError.unwrapOptionField("priceList", priceList)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pricing.model.GetProductsResponse
  ) extends zio.aws.pricing.model.GetProductsResponse.ReadOnly {
    override val formatVersion: Option[String] =
      scala.Option(impl.formatVersion()).map(value => value: String)
    override val priceList: Option[List[PriceListItemJSON]] = scala
      .Option(impl.priceList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pricing.model.primitives.PriceListItemJSON(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pricing.model.GetProductsResponse
  ): zio.aws.pricing.model.GetProductsResponse.ReadOnly = new Wrapper(impl)
}
