package zio.aws.pricing.model
import scala.jdk.CollectionConverters.*
sealed trait FilterType {
  def unwrap: software.amazon.awssdk.services.pricing.model.FilterType
}
object FilterType {
  def wrap(
      value: software.amazon.awssdk.services.pricing.model.FilterType
  ): zio.aws.pricing.model.FilterType = value match {
    case software.amazon.awssdk.services.pricing.model.FilterType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pricing.model.FilterType.TERM_MATCH =>
      val r = TERM_MATCH
      r
  }
  case object unknownToSdkVersion extends zio.aws.pricing.model.FilterType {
    override def unwrap
        : software.amazon.awssdk.services.pricing.model.FilterType =
      software.amazon.awssdk.services.pricing.model.FilterType.UNKNOWN_TO_SDK_VERSION
  }
  case object TERM_MATCH extends zio.aws.pricing.model.FilterType {
    override def unwrap
        : software.amazon.awssdk.services.pricing.model.FilterType =
      software.amazon.awssdk.services.pricing.model.FilterType.TERM_MATCH
  }
}
