package zio.aws.pricing.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.pricing.model.primitives.BoxedInteger
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetAttributeValuesRequest(
    serviceCode: String,
    attributeName: String,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[BoxedInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest = {
    import GetAttributeValuesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest
      .builder()
      .serviceCode(serviceCode: java.lang.String)
      .attributeName(attributeName: java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.pricing.model.GetAttributeValuesRequest.ReadOnly =
    zio.aws.pricing.model.GetAttributeValuesRequest.wrap(buildAwsValue())
}
object GetAttributeValuesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pricing.model.GetAttributeValuesRequest =
      zio.aws.pricing.model.GetAttributeValuesRequest(
        serviceCode,
        attributeName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def serviceCode: String
    def attributeName: String
    def nextToken: Optional[String]
    def maxResults: Optional[BoxedInteger]
    def getServiceCode: ZIO[Any, Nothing, String] = ZIO.succeed(serviceCode)
    def getAttributeName: ZIO[Any, Nothing, String] = ZIO.succeed(attributeName)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest
  ) extends zio.aws.pricing.model.GetAttributeValuesRequest.ReadOnly {
    override val serviceCode: String = impl.serviceCode(): String
    override val attributeName: String = impl.attributeName(): String
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: BoxedInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest
  ): zio.aws.pricing.model.GetAttributeValuesRequest.ReadOnly = new Wrapper(
    impl
  )
}
